% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_balanced_tree.R
\name{add_balanced_tree}
\alias{add_balanced_tree}
\title{Add a balanced tree to the graph}
\usage{
add_balanced_tree(graph, k, h, type = NULL, label = TRUE, rel = NULL,
  node_aes = NULL, edge_aes = NULL, node_data = NULL, edge_data = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{k}{the branching factor for
the tree.}

\item{h}{the height of the tree.}

\item{type}{an optional string that
describes the entity type for the
nodes to be added.}

\item{label}{either a vector object
of length \code{n} that provides
optional labels for the new nodes, or,
a boolean value where setting to
\code{TRUE} ascribes node IDs to the
label and \code{FALSE} yields a blank
label.}

\item{rel}{an optional string for
providing a relationship label to all
new edges created in the node tree.}

\item{node_aes}{an optional list
of named vectors comprising node
aesthetic attributes. The helper
function \code{node_aes()} is
strongly recommended for use here
as it contains arguments for each
of the accepted node aesthetic
attributes (e.g., \code{shape},
\code{style}, \code{color},
\code{fillcolor}).}

\item{edge_aes}{an optional list
of named vectors comprising edge
aesthetic attributes. The helper
function \code{edge_aes()} is
strongly recommended for use here
as it contains arguments for each
of the accepted edge aesthetic
attributes (e.g., \code{shape},
\code{style}, \code{penwidth},
\code{color}).}

\item{node_data}{an optional list
of named vectors comprising node
data attributes. The helper
function \code{node_data()} is
strongly recommended for use here
as it helps bind data specifically
to the created nodes.}

\item{edge_data}{an optional list
of named vectors comprising edge
data attributes. The helper function
\code{edge_data()} is strongly
recommended for use here as it helps
bind data specifically to the
created edges.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
With a graph object of class
\code{dgr_graph}, add a balanced tree
to the graph.
}
\examples{
# Create a new graph and
# add 2 different types of
# balanced trees of height
# 2 (branching twice) and
# different branching ratios
graph <-
  create_graph() \%>\%
  add_balanced_tree(
    k = 2,
    h = 2,
    type = "binary") \%>\%
  add_balanced_tree(
    k = 3,
    h = 2,
    type = "tertiary")

# Get some node information
# from this graph
graph \%>\%
  get_node_info() \%>\%
  head(5)

# Node and edge aesthetic and data
# attributes can be specified in
# the `node_aes`, `edge_aes`,
# `node_data`, and `edge_data`
# arguments
graph_w_attrs <-
  create_graph() \%>\%
  add_balanced_tree(
    k = 2,
    h = 2,
    label = c(
      "one", "two",
      "three", "four",
      "five", "six", "seven"),
    type = c(
      "a", "b", "b", "c",
      "c", "c", "c"),
    rel = "A",
    node_aes = node_aes(
      fillcolor = "steelblue"),
    node_data = node_data(
      value = c(
        1.6, 2.8, 3.4, 8.3,
        3.8, 5.2, 3.2)),
    edge_aes = edge_aes(
      color = "red",
      penwidth = 1.2))

# Get the first three rows of
# the graph's node data frame
graph_w_attrs \%>\%
  get_node_df() \%>\%
  head(3)

# Get the first three rows of
# the graph's edge data frame
graph_w_attrs \%>\%
  get_edge_df() \%>\%
  head(3)
}
