% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visnetwork.R
\name{visnetwork}
\alias{visnetwork}
\title{Render graph with visNetwork}
\usage{
visnetwork(graph)
}
\arguments{
\item{graph}{a \code{dgr_graph} object, created using the
\code{create_graph} function.}
}
\description{
Render a graph object with the visNetwork R package.
}
\examples{
\dontrun{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 6,
    label = TRUE,
    fillcolor = c("lightgrey", "red", "orange",
                  "pink", "aqua", "yellow"),
    shape = "circle",
    value = c(2, 1, 0.5, 1, 1.8, 1),
    type = c("1", "1", "1", "2", "2", "2"),
    x = c(1, 2, 3, 4, 5, 6),
    y = c(-2, -1, 0, 6, 4, 1))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3, 4, 6, 5),
    to = c(4, 3, 1, 3, 1, 4),
    color = c("green", "green", "grey",
              "grey", "blue", "blue"),
    rel = "leading_to")

# Create a graph object
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

visnetwork(graph)
}
}

