% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.statistics.R
\name{ds.statistics}
\alias{ds.statistics}
\title{Calculation of the Statistic Measures}
\usage{
ds.statistics(data, tojson = FALSE)
}
\arguments{
\item{data}{A numeric vector, matrix or data frame}

\item{tojson}{If TRUE the results are returned in json format, default returns a list}
}
\value{
A list or json file with the following components:
\itemize{
\item Min The minimum observed value of the input data
\item Max The maximum observed value of the input data
\item Range The range, defined as the difference of the maximum and the minimum value.
\item Mean The average value of the input data
\item Median The median value of the input data
\item Quantiles The 25\% and 75\% percentiles
\item Variance The variance of the input data
\item Standard Deviation The standard deviation of the input data
\item Skewness The Skewness of the input data
\item Kurtosis The Kurtosis of the input data
}
}
\description{
This function calculates the basic descriptive measures of the input dataset.
}
\details{
This function returns the following values of the input data: minimum, maximum, range, mean, median, first and third quantiles, variance,
standart deviation, skewness and kurtosis.
}
\examples{
# with matrix as an input and json outpout
Matrix <- cbind(Uni05 = (1:200)/21, Norm = rnorm(200),
        `5T` = rt(200, df = 5), Gam2 = rgamma(200, shape = 2))
ds.statistics(Matrix, tojson = TRUE)

# with vector as an input
vec <- as.vector(iris$Sepal.Width)
ds.statistics(vec, tojson = FALSE)

# with iris data frame as an input
ds.statistics(iris, tojson = FALSE)

# OpenBudgets.eu Dataset Example:
ds.statistics(Wuppertal_df$Amount, tojson = TRUE)

}
\seealso{
\code{\link{open_spending.ds}}
}
\author{
Aikaterini Chatzopoulou, Kleanthis Koupidis, Charalampos Bratsas
}
