% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ddPlot}
\alias{ddPlot}
\title{Depth versus depth plot}
\usage{
ddPlot(x, y, scale = FALSE, location = FALSE, name_x = "X",
  name_y = "Y", title = "Depth vs. depth plot", ...)
}
\arguments{
\item{x}{The first or only data sample for ddPlot.}

\item{y}{The second data sample. \code{x} and \code{y} must be of the same space.}

\item{scale}{logical. determines whether the dispersion is to be aligned.}

\item{location}{determines whether the location is to be aligned to 0 vector with depth median.}

\item{name_x}{name for data set x. It will be passed to drawing function.}

\item{name_y}{name for data set y.}

\item{title}{title of the plot.}

\item{...}{Parameters passed to depth function}
}
\description{
Produces a DD plot which allows to compare two multivirate datasets or to compare a subject dataset with theoretical distribution.
}
\details{
For two probability distributions  \eqn{ F }  and  \eqn{ G } , both in  \eqn{ {{{R}}^{d}} } , we can define {depth vs. depth} plot being very useful generalization of the one dimensional quantile-quantile plot:    \deqn{ DD(F,G)=\left\{ \left( D({z},F),D({z},G) \right),{z}\in {{{R}}^{d}} \right\} }
Its sample counterpart calculated for two samples  \eqn{ {{{X}}^{n}}=\{{{X}_{1}},.,{{X}_{n}}\} }  from  \eqn{ F } , and  \eqn{ {{Y}^{m}}=\{{{Y}_{1}},...,{{Y}_{m}}\} }  from  \eqn{ G }  is defined as
\deqn{ DD({{F}_{n}},{{G}_{m}})=\left\{ \left( D({z},{{F}_{n}}),D({z},{{G}_{m}}) \right),{z}\in \{{{{X}}^{n}}\cup {{{Y}}^{m}}\} \right\}}
}
\examples{
require(sn)
require(mvtnorm)

# EXAMPLE 1: Location difference
standard = mvrnorm(1000, c(0,0), diag(2))
shift    =  mvrnorm(1000, c(0.5, 0), diag(2))
ddPlot(x = standard, y = shift, title = "Difference in position")
ddPlot(x = standard, y = shift, location = TRUE, title = "Location aligned")

## EXAMPLE 2: Scale difference
standard <- mvrnorm(1000, c(0,0), diag(2))
scale <- mvrnorm(1000, c(0,0), 4*diag(2))
ddPlot(x=standard, y=scale)
ddPlot(x=standard, y=scale, scale=TRUE)
}
\author{
Daniel Kosiorowski, Mateusz Bocian, Anna Wegrzynkiewicz and Zygmunt Zawadzki from Cracow University of Economics.
}
\references{
Liu, R.Y., Parelius, J.M. and Singh, K. (1999), Multivariate analysis by data depth: Descriptive statistics, graphics and inference (with discussion), \emph{Ann. Statist.}, \bold{27}, 822--831.

           Liu, R.Y., Singh K. (1993), A Quality Index Based on Data Depth and Multivariate Rank Test, \emph{Journal of the American Statistical Association} vol. 88.
}

