% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dc.R
\name{plot_dc}
\alias{plot_dc}
\title{Plot the survival function}
\usage{
plot_dc(object, scenario = c("t", "c", "both"))
}
\arguments{
\item{object}{an object of the class "dcensoring".}

\item{scenario}{which defines the scenario in the graph (t: failure times, c: dependent censoring times, or both).}
}
\value{
a survival function graph of the fitted model.
}
\description{
This graph helps to visualize the survival function.
}
\details{
In order to smooth the line presented in the graph, we used the 'lowess' function. So, it can result in a non-monotonous survival function.
}
\examples{
\donttest{
fit <- dependent.censoring(formula = time ~ x1 | x3, data=KidneyMimic, delta_t=KidneyMimic$delta_t,
                          delta_c=KidneyMimic$delta_c, ident=KidneyMimic$ident, dist = "mep")
plot_dc(fit, scenario = "both")
}

}
