/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots;

import edu.cens.spatial.plots.MapController;
import edu.cens.spatial.plots.MapPanel;
import edu.cens.spatial.plots.SpatialPlotBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.REngine.REXP;
import org.rosuda.deducer.Deducer;
import org.rosuda.javaGD.PlotPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewPanel
extends JPanel
implements ComponentListener {
    JLayeredPane pane = new JLayeredPane();
    MapPanel map;
    PlotPanel plotPanel;
    String tp = "osm";
    SpatialPlotBuilder parent;
    MapController mapController;

    public ViewPanel(int n, int n2, SpatialPlotBuilder spatialPlotBuilder) {
        this.parent = spatialPlotBuilder;
        this.parent.addComponentListener(this);
        this.setLayout(new BorderLayout());
        this.add(this.pane);
        this.initMap();
        this.plotPanel = new PlotPanel(n, n2);
        this.plotPanel.setOpaque(false);
        this.plotPanel.setBackground(null);
    }

    public void refreshPlot() {
        this.plotPanel.initRefresh();
    }

    public ViewPanel(PlotPanel plotPanel, SpatialPlotBuilder spatialPlotBuilder) {
        this.parent = spatialPlotBuilder;
        this.parent.addComponentListener(this);
        this.setLayout(new BorderLayout());
        this.pane.setLayout((LayoutManager)new AnchorLayout());
        this.plotPanel = plotPanel;
        this.plotPanel.setOpaque(false);
        this.plotPanel.setBackground(new Color(255, 0, 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setBackground(new Color(255, 0, 0, 0));
        jPanel.add(new JLabel("blaa blaa"));
        this.pane.add((Component)this.plotPanel, new AnchorConstraint(0, 0, 0, 0, 2, 2, 2, 2), 1);
        this.pane.setLayer((Component)this.plotPanel, 1);
        this.initMap();
        this.add(this.pane);
        this.validate();
        this.repaint();
    }

    public void initMap() {
        this.map = new MapPanel(this.pane);
        this.map.setTileSource((TileSource)new OsmTileSource.Mapnik());
        this.mapController = new MapController(this.map, this.parent);
        this.map.addPlusListener(this.mapController);
        this.map.addMinusListener(this.mapController);
        this.map.addSliderListener(this.mapController);
        this.mapController.addListenersTo((Component)this.plotPanel);
        try {
            this.map.setTileLoader((TileLoader)new OsmFileCacheTileLoader((TileLoaderListener)this.map));
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.map.setMapMarkerVisible(false);
        this.map.setZoomContolsVisible(true);
        this.pane.add((Component)((Object)this.map), new AnchorConstraint(0, 0, 0, 0, 2, 2, 2, 2), 0);
        this.pane.setLayer((Component)((Object)this.map), 0);
    }

    public Vector<Double> getUpperLeftCoordinate() {
        Vector<Double> vector = new Vector<Double>(2);
        Coordinate coordinate = this.map.getPosition(0, 0);
        if (coordinate.getLon() > 180.0 || coordinate.getLon() < -180.0 || coordinate.getLat() > 85.0 || coordinate.getLat() < -85.0) {
            vector.add(0.0);
            vector.add(0.0);
            return vector;
        }
        String string = "projectMercator(" + coordinate.getLat() + "," + coordinate.getLon() + ")";
        REXP rEXP = Deducer.eval((String)string);
        try {
            double[] dArray = rEXP.asDoubles();
            vector.add(dArray[0]);
            vector.add(dArray[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    public Vector<Double> getLowerRightCoordinate() {
        Vector<Double> vector = new Vector<Double>(2);
        Coordinate coordinate = this.map.getPosition(0 + this.plotPanel.getWidth(), 0 + this.plotPanel.getHeight());
        if (coordinate.getLon() > 180.0 || coordinate.getLon() < -180.0 || coordinate.getLat() > 85.0 || coordinate.getLat() < -85.0) {
            vector.add(0.0);
            vector.add(0.0);
            return vector;
        }
        String string = "projectMercator(" + coordinate.getLat() + "," + coordinate.getLon() + ")";
        REXP rEXP = Deducer.eval((String)string);
        try {
            double[] dArray = rEXP.asDoubles();
            vector.add(dArray[0]);
            vector.add(dArray[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    public Vector<Double> getLowerRightLatLong() {
        Coordinate coordinate = this.map.getPosition(0 + this.plotPanel.getWidth(), 0 + this.plotPanel.getHeight());
        Vector<Double> vector = new Vector<Double>(2);
        vector.add(coordinate.getLat());
        vector.add(coordinate.getLon());
        return vector;
    }

    public Vector<Double> getUpperLeftLatLong() {
        Coordinate coordinate = this.map.getPosition(0, 0);
        Vector<Double> vector = new Vector<Double>(2);
        vector.add(coordinate.getLat());
        vector.add(coordinate.getLon());
        return vector;
    }

    public int getZoom() {
        return this.map.getZoom();
    }

    public void setTileSource(String string) {
        if ("bing".equals(string)) {
            this.tp = "bing";
            this.map.setTileSource((TileSource)new BingAerialTileSource());
        } else if ("osm".equals(string)) {
            this.tp = "osm";
            this.map.setTileSource((TileSource)new OsmTileSource.Mapnik());
        }
    }

    public String getTileSourceType() {
        return this.tp;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.parent.updatePlot();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public void beginSubsetting() {
        this.mapController.startSubsetting();
    }
}

