/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class Demo
extends JFrame {
    private static final long serialVersionUID = 1L;

    public Demo() {
        super("JMapViewer Demo");
        JComboBox<TileLoader> tileLoaderSelector;
        this.setSize(400, 400);
        final JMapViewer map = new JMapViewer();
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        this.setExtendedState(6);
        JPanel panel = new JPanel();
        JPanel helpPanel = new JPanel();
        this.add((Component)panel, "North");
        this.add((Component)helpPanel, "South");
        JLabel helpLabel = new JLabel("Use right mouse button to move,\n left double click or mouse wheel to zoom.");
        helpPanel.add(helpLabel);
        JButton button = new JButton("setDisplayToFitMapMarkers");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                map.setDisplayToFitMapMarkers();
            }
        });
        JComboBox<TileSource> tileSourceSelector = new JComboBox<TileSource>(new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.TilesAtHome(), new OsmTileSource.CycleMap(), new BingAerialTileSource()});
        tileSourceSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                map.setTileSource((TileSource)e.getItem());
            }
        });
        try {
            tileLoaderSelector = new JComboBox<TileLoader>(new TileLoader[]{new OsmFileCacheTileLoader(map), new OsmTileLoader(map)});
        }
        catch (IOException e) {
            tileLoaderSelector = new JComboBox<TileLoader>(new TileLoader[]{new OsmTileLoader(map)});
        }
        tileLoaderSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                map.setTileLoader((TileLoader)e.getItem());
            }
        });
        map.setTileLoader((TileLoader)tileLoaderSelector.getSelectedItem());
        panel.add(tileSourceSelector);
        panel.add(tileLoaderSelector);
        final JCheckBox showMapMarker = new JCheckBox("Map markers visible");
        showMapMarker.setSelected(map.getMapMarkersVisible());
        showMapMarker.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                map.setMapMarkerVisible(showMapMarker.isSelected());
            }
        });
        panel.add(showMapMarker);
        final JCheckBox showTileGrid = new JCheckBox("Tile grid visible");
        showTileGrid.setSelected(map.isTileGridVisible());
        showTileGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                map.setTileGridVisible(showTileGrid.isSelected());
            }
        });
        panel.add(showTileGrid);
        final JCheckBox showZoomControls = new JCheckBox("Show zoom controls");
        showZoomControls.setSelected(map.getZoomContolsVisible());
        showZoomControls.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                map.setZoomContolsVisible(showZoomControls.isSelected());
            }
        });
        panel.add(showZoomControls);
        panel.add(button);
        this.add((Component)map, "Center");
        map.addMapMarker(new MapMarkerDot(49.814284999, 8.642065999));
        map.addMapMarker(new MapMarkerDot(49.91, 8.24));
        map.addMapMarker(new MapMarkerDot(49.71, 8.64));
        map.addMapMarker(new MapMarkerDot(48.71, -1.0));
        map.addMapMarker(new MapMarkerDot(49.8588, 8.643));
    }

    public static void main(String[] args) {
        new Demo().setVisible(true);
    }
}

