/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.menu.SubsetDialog;
import org.rosuda.deducer.menu.SubsetPanel;
import org.rosuda.deducer.models.GLMBuilder;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.toolkit.AddButton;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.RemoveButton;
import org.rosuda.deducer.toolkit.SingletonAddRemoveButton;
import org.rosuda.deducer.toolkit.SingletonDJList;
import org.rosuda.deducer.toolkit.VariableSelector;

public class GLMDialog
extends JDialog
implements ActionListener {
    protected VariableSelector variableSelector;
    protected JPanel contPanel;
    protected JLabel typeLabel;
    protected JComboBox type;
    protected JButton addOutcome;
    protected JPanel weightPanel;
    protected SubsetPanel subset;
    protected JPanel subsetPanel;
    protected SingletonDJList weights;
    protected JButton addWeight;
    protected SingletonDJList outcome;
    protected JPanel outcomePanel;
    protected HelpButton help;
    protected OkayCancelPanel okayCancelPanel;
    protected RemoveButton removeFactor;
    protected DJList factorVars;
    protected DJList numericVars;
    protected JScrollPane factScroller;
    protected JScrollPane numericScroller;
    protected JPanel factPanel;
    protected static DefaultComboBoxModel families = new DefaultComboBoxModel<String>(new String[]{"gaussian()", "binomial()", "poisson()", "Gamma()", "inverse.gaussian()", "quasibinomial()", "quasipoisson()", "other..."});
    protected AddButton addFactor;
    protected RemoveButton removeNumeric;
    protected AddButton addNumeric;
    protected GLMModel model = new GLMModel();
    protected GLMModel modelOnOpen = new GLMModel();
    protected static GLMModel lastModel;

    public GLMDialog(JDialog jDialog, GLMModel gLMModel) {
        super(jDialog);
        gLMModel.copyInto(this.modelOnOpen);
        this.initGUI();
        this.setModel(gLMModel);
    }

    public GLMDialog(JFrame jFrame, GLMModel gLMModel) {
        super(jFrame);
        gLMModel.copyInto(this.modelOnOpen);
        this.initGUI();
        this.setModel(gLMModel);
    }

    public GLMDialog(GLMModel gLMModel) {
        gLMModel.copyInto(this.modelOnOpen);
        this.initGUI();
        this.setModel(gLMModel);
    }

    public GLMDialog(JFrame jFrame) {
        this(jFrame, lastModel == null ? new GLMModel() : lastModel);
    }

    protected void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.variableSelector = new VariableSelector();
            this.weightPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.weightPanel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.weightPanel, new AnchorConstraint(644, 978, 730, 568, 1, 1, 1, 1));
            this.weightPanel.setBorder(BorderFactory.createTitledBorder("Weights"));
            this.weightPanel.setPreferredSize(new Dimension(223, 52));
            DefaultListModel defaultListModel = new DefaultListModel();
            this.weights = new SingletonDJList();
            this.weightPanel.add((Component)this.weights, "Center");
            this.weights.setModel(defaultListModel);
            this.addWeight = new SingletonAddRemoveButton(new String[]{"Add Weighting Variable", "Remove Weighting Variable"}, new String[]{"Add Weighting Variable", "Remove Weighting Variable"}, this.weights, this.variableSelector);
            this.getContentPane().add((Component)this.addWeight, new AnchorConstraint(664, 534, 724, 467, 1, 1, 0, 0));
            this.addWeight.setPreferredSize(new Dimension(36, 36));
            this.subsetPanel = new JPanel();
            borderLayout = new BorderLayout();
            this.subsetPanel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.subsetPanel, new AnchorConstraint(740, 978, 872, 568, 1, 1, 1, 1));
            this.subsetPanel.setBorder(BorderFactory.createTitledBorder("Subset"));
            this.subsetPanel.setPreferredSize(new Dimension(223, 79));
            this.subset = new SubsetPanel(this.variableSelector.getJComboBox());
            this.subsetPanel.add((Component)this.subset, "Center");
            this.subset.setPreferredSize(new Dimension(213, 53));
            this.contPanel = new JPanel();
            borderLayout = new BorderLayout();
            this.contPanel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.contPanel, new AnchorConstraint(115, 978, 352, 568, 1, 1, 1, 1));
            this.contPanel.setBorder(BorderFactory.createTitledBorder(null, "As Numeric", 4, 0));
            this.contPanel.setPreferredSize(new Dimension(223, 142));
            this.numericScroller = new JScrollPane();
            this.contPanel.add((Component)this.numericScroller, "Center");
            this.numericVars = new DJList();
            this.numericVars.setModel(new DefaultListModel());
            this.numericScroller.setViewportView(this.numericVars);
            this.factPanel = new JPanel();
            borderLayout = new BorderLayout();
            this.factPanel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.factPanel, new AnchorConstraint(362, 978, 634, 568, 1, 1, 1, 1));
            this.factPanel.setBorder(BorderFactory.createTitledBorder("As Factor"));
            this.factPanel.setPreferredSize(new Dimension(223, 163));
            this.factScroller = new JScrollPane();
            this.factPanel.add((Component)this.factScroller, "Center");
            this.factorVars = new DJList();
            this.factorVars.setModel(new DefaultListModel());
            this.factScroller.setViewportView(this.factorVars);
            this.type = new JComboBox();
            this.getContentPane().add((Component)this.type, new AnchorConstraint(839, 431, 874, 64, 1, 1, 0, 2));
            this.type.setModel(families);
            this.type.setPreferredSize(new Dimension(170, 21));
            this.type.addActionListener(this);
            this.typeLabel = new JLabel();
            this.getContentPane().add((Component)this.typeLabel, new AnchorConstraint(839, 487, 872, 11, 1, 0, 0, 0));
            this.typeLabel.setText("Family:");
            this.typeLabel.setHorizontalAlignment(4);
            this.typeLabel.setPreferredSize(new Dimension(46, 20));
            this.addNumeric = new AddButton("Add Numeric Variables", this.variableSelector, this.numericVars);
            this.getContentPane().add((Component)this.addNumeric, new AnchorConstraint(179, 534, 239, 467, 1, 1, 0, 0));
            this.addNumeric.setPreferredSize(new Dimension(36, 36));
            this.removeNumeric = new RemoveButton("Remove Numeric Variables", this.variableSelector, this.numericVars);
            this.getContentPane().add((Component)this.removeNumeric, new AnchorConstraint(239, 534, 299, 467, 1, 1, 0, 0));
            this.removeNumeric.setPreferredSize(new Dimension(36, 36));
            this.addFactor = new AddButton("Add Factor Variables", this.variableSelector, this.factorVars);
            this.getContentPane().add((Component)this.addFactor, new AnchorConstraint(444, 534, 504, 467, 1, 1, 0, 0));
            this.addFactor.setPreferredSize(new Dimension(36, 36));
            this.removeFactor = new RemoveButton("Remove Factor Variables", this.variableSelector, this.factorVars);
            this.getContentPane().add((Component)this.removeFactor, new AnchorConstraint(504, 534, 564, 467, 1, 1, 0, 0));
            this.removeFactor.setPreferredSize(new Dimension(36, 36));
            this.okayCancelPanel = new OkayCancelPanel(true, true, this);
            this.getContentPane().add((Component)this.okayCancelPanel, new AnchorConstraint(904, 978, 980, 300, 0, 1, 1, 0));
            this.okayCancelPanel.setPreferredSize(new Dimension(400, 46));
            this.okayCancelPanel.getApproveButton().setText("Continue");
            this.okayCancelPanel.getApproveButton().setActionCommand("Continue");
            this.help = new HelpButton("pmwiki.php?n=Main.GeneralizedLinearModel");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(0, 0, 960, 11, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.outcomePanel = new JPanel();
            borderLayout = new BorderLayout();
            this.outcomePanel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.outcomePanel, new AnchorConstraint(20, 978, 105, 568, 1, 1, 1, 1));
            this.outcomePanel.setBorder(BorderFactory.createTitledBorder("Outcome"));
            this.outcomePanel.setPreferredSize(new Dimension(223, 51));
            defaultListModel = new DefaultListModel();
            this.outcome = new SingletonDJList();
            this.outcomePanel.add((Component)this.outcome, "Center");
            this.outcome.setModel(defaultListModel);
            this.addOutcome = new SingletonAddRemoveButton(new String[]{"Add Outcome", "Remove Outcome"}, new String[]{"Add Outcome", "Remove Outcome"}, this.outcome, this.variableSelector);
            this.getContentPane().add((Component)this.addOutcome, new AnchorConstraint(34, 534, 94, 467, 1, 1, 1, 1));
            this.addOutcome.setPreferredSize(new Dimension(36, 36));
            this.getContentPane().add((Component)this.variableSelector, new AnchorConstraint(20, 431, 819, 22, 1, 1, 1, 1));
            this.variableSelector.setPreferredSize(new Dimension(222, 479));
            this.variableSelector.getJComboBox().addActionListener(this);
            this.setSize(552, 634);
            this.setTitle("Generalized Linear Model");
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public static void setLastModel(GLMModel gLMModel) {
        lastModel = gLMModel;
    }

    public void resetModel() {
        this.setModel(new GLMModel());
    }

    public void setModel(GLMModel gLMModel) {
        this.variableSelector.setSelectedData(gLMModel.data);
        boolean bl = this.variableSelector.removeAll(gLMModel.outcomeVars);
        if (!bl) {
            this.resetModel();
            return;
        }
        this.outcome.setModel(gLMModel.outcomeVars);
        bl = this.variableSelector.removeAll(gLMModel.numericVars);
        if (!bl) {
            this.resetModel();
            return;
        }
        this.numericVars.setModel(gLMModel.numericVars);
        bl = this.variableSelector.removeAll(gLMModel.factorVars);
        if (!bl) {
            this.resetModel();
            return;
        }
        this.factorVars.setModel(gLMModel.factorVars);
        bl = this.variableSelector.removeAll(gLMModel.weights);
        if (!bl) {
            this.resetModel();
            return;
        }
        this.weights.setModel(gLMModel.weights);
        if (SubsetDialog.isValidSubsetExp(gLMModel.subset, gLMModel.data)) {
            this.subset.setText(gLMModel.subset);
        }
        if (families.getIndexOf(gLMModel.family) >= 0) {
            families.setSelectedItem(gLMModel.family);
        } else {
            families.insertElementAt(gLMModel.family, families.getSize() - 1);
        }
        this.model = gLMModel;
    }

    public void updateModel() {
        int n;
        this.model.factorVars = (DefaultListModel)this.factorVars.getModel();
        this.model.numericVars = (DefaultListModel)this.numericVars.getModel();
        this.model.outcomeVars = (DefaultListModel)this.outcome.getModel();
        if (this.model.outcomes.size() == 0) {
            this.model.outcomes = (DefaultListModel)this.outcome.getModel();
        } else if (!this.model.outcomes.getElementAt(0).toString().contains((String)this.model.outcomeVars.get(0))) {
            this.model.outcomes = (DefaultListModel)this.outcome.getModel();
        }
        this.model.data = this.variableSelector.getSelectedData();
        this.model.subset = this.subset.getText();
        this.model.weights = (DefaultListModel)this.weights.getModel();
        this.model.family = (String)families.getSelectedItem();
        boolean bl = true;
        for (n = 0; n < this.modelOnOpen.numericVars.size(); ++n) {
            if (this.model.numericVars.contains(this.modelOnOpen.numericVars.get(n))) continue;
            bl = false;
        }
        for (n = 0; n < this.modelOnOpen.factorVars.size(); ++n) {
            if (this.model.factorVars.contains(this.modelOnOpen.factorVars.get(n))) continue;
            bl = false;
        }
        if (!bl) {
            this.model.terms = new DefaultListModel();
        }
    }

    public void setDataName(String string) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
        }
    }

    public boolean valid() {
        if (this.outcome.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(this, "Please specify an outcome variable");
            return false;
        }
        if (this.factorVars.getModel().getSize() == 0 && this.numericVars.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(this, "Please specify a predictor variable (numeric or factor).");
            return false;
        }
        return true;
    }

    public void continueClicked() {
        if (!this.valid()) {
            return;
        }
        this.updateModel();
        GLMBuilder gLMBuilder = new GLMBuilder(this.model);
        gLMBuilder.setLocationRelativeTo(this);
        gLMBuilder.setVisible(true);
        WindowTracker.addWindow(gLMBuilder);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Continue") {
            this.continueClicked();
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "comboBoxChanged" && actionEvent.getSource() == this.type && this.type.getSelectedItem().equals("other...")) {
            String string2 = JOptionPane.showInputDialog(this, (Object)"Custom GLM Family");
            if (string2 == null || string2 == "") {
                this.type.setSelectedIndex(0);
            } else {
                families.insertElementAt(string2, families.getSize() - 1);
                this.type.setSelectedItem(string2);
            }
        } else if (string == "comboBoxChanged" && actionEvent.getSource() == this.variableSelector.getJComboBox()) {
            this.resetModel();
        } else if (string == "Reset") {
            this.variableSelector.reset();
            this.resetModel();
        }
    }
}

