/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.rosuda.JGR.JGRConsole;
import org.rosuda.JGR.JGRPackageManager;
import org.rosuda.JGR.MonitoredEval;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.ConsoleSync;
import org.rosuda.JGR.toolkit.JGRListener;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.SplashScreen;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.util.Global;
import org.rosuda.util.Platform;

public class JGR {
    public static final String VERSION = "1.7-18";
    public static final String TITLE = "JGR";
    public static final String SUBTITLE = "Java Gui for R";
    public static final String DEVELTIME = "2003 - 2015";
    public static final String INSTITUTION = "RoSuDa, Univ. Augsburg";
    public static final String AUTHOR1 = "Markus Helbig";
    public static final String AUTHOR2 = "Simon Urbanek";
    public static final String AUTHOR3 = "Ian Fellows";
    public static final String WEBSITE = "http://www.rosuda.org";
    public static final String SPLASH = "jgrsplash.jpg";
    public static JGRConsole MAINRCONSOLE = null;
    public static Vector RHISTORY = null;
    public static String RHOME = null;
    private static REngine rEngine = null;
    public static ConsoleSync rSync = new ConsoleSync();
    public static Vector DATA = new Vector();
    public static Vector MODELS = new Vector();
    public static Vector OTHERS = new Vector();
    public static Vector FUNCTIONS = new Vector();
    public static Vector OBJECTS = new Vector();
    public static Vector KEYWORDS = new Vector();
    public static Vector KEYWORDS_OBJECTS = new Vector();
    public static boolean STARTED = false;
    private static JGRListener jgrlistener = null;
    public static SplashScreen splash;
    public static String[] arguments;
    private static String[] rargs;
    private static boolean JGRmain;
    private static String tempWD;
    private static String launcherPackages;
    private static boolean showSplash;

    public JGR() {
        SVar.int_NA = Integer.MIN_VALUE;
        Object object = new Object();
        JGRPackageManager.neededPackages.put("base", object);
        JGRPackageManager.neededPackages.put("graphics", object);
        JGRPackageManager.neededPackages.put("grDevices", object);
        JGRPackageManager.neededPackages.put("utils", object);
        JGRPackageManager.neededPackages.put("methods", object);
        JGRPackageManager.neededPackages.put("stats", object);
        JGRPackageManager.neededPackages.put("datasets", object);
        JGRPackageManager.neededPackages.put(TITLE, object);
        JGRPackageManager.neededPackages.put("rJava", object);
        JGRPackageManager.neededPackages.put("JavaGD", object);
        JGRPackageManager.neededPackages.put("iplots", object);
        Platform.initPlatform((String)"org.rosuda.JGR.toolkit.");
        JGRPrefs.initialize();
        splash = new SplashScreen();
        if (showSplash) {
            splash.start();
        }
        JGR.readHistory();
        MAINRCONSOLE = new JGRConsole();
        MAINRCONSOLE.setWorking(true);
        if (showSplash) {
            splash.toFront();
        }
        if (showSplash && System.getProperty("os.name").startsWith("Window")) {
            splash.stop();
            JGRPrefs.isWindows = true;
        }
        try {
            System.loadLibrary("jri");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = "all environment variables (PATH, LD_LIBRARY_PATH, etc.) are setup properly (see supplied script)";
            String string2 = "libjri.so";
            if (System.getProperty("os.name").startsWith("Window")) {
                string = "you start JGR by double-clicking the JGR.exe program";
                string2 = "jri.dll";
            }
            if (System.getProperty("os.name").startsWith("Mac")) {
                string = "you start JGR by double-clicking the JGR application";
                string2 = "libjri.jnilib";
            }
            JOptionPane.showMessageDialog(null, "Cannot find Java/R Interface (JRI) library (" + string2 + ").\nPlease make sure " + string + ".", "Cannot find JRI library", 0);
            System.err.println("Cannot find JRI native library!\n");
            unsatisfiedLinkError.printStackTrace();
            System.exit(1);
        }
        if (!Rengine.versionCheck()) {
            JOptionPane.showMessageDialog(null, "Java/R Interface (JRI) library doesn't match this JGR version.\nPlease update JGR and JRI to the latest version.", "Version Mismatch", 0);
            System.exit(2);
        }
        try {
            rEngine = new JRIEngine(rargs, MAINRCONSOLE);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Unable to start R: " + exception.getMessage(), "REngine problem", 0);
            System.err.println("Cannot start REngine " + exception);
            System.exit(1);
        }
        try {
            rEngine.assign(".$JGR", new REXPString(JGRPrefs.workingDirectory));
            JGR.eval("try({setwd(`.$JGR`); rm(`.$JGR`)},silent=T)");
        }
        catch (REngineException rEngineException) {
            new ErrorMsg(rEngineException);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            new ErrorMsg(rEXPMismatchException);
        }
        RController.requirePackages(TITLE);
        JGRPackageManager.defaultPackages = RController.getJgrDefaultPackages();
        if (launcherPackages != null) {
            RController.requirePackages(launcherPackages);
        }
        if (JGRPrefs.defaultPackages != null) {
            RController.requirePackages(JGRPrefs.defaultPackages);
        }
        STARTED = true;
        if (showSplash && !System.getProperty("os.name").startsWith("Win")) {
            splash.stop();
        }
        MAINRCONSOLE.execute("", false);
        MAINRCONSOLE.toFront();
        JGR.MAINRCONSOLE.input.requestFocus();
        int n = MAINRCONSOLE.getFontWidth();
        if (n > 0) {
            JGR.threadedEval("options(width=" + n + ")");
        }
        System.setOut(MAINRCONSOLE.getStdOutPrintStream());
        System.setErr(MAINRCONSOLE.getStdErrPrintStream());
        new Refresher().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static REXP idleEval(String string) throws REngineException, REXPMismatchException {
        if (JGR.getREngine() == null) {
            throw new REngineException(null, "REngine not available");
        }
        REXP rEXP = null;
        int n = JGR.getREngine().tryLock();
        if (n != 0) {
            try {
                rEXP = JGR.getREngine().parseAndEval(string, null, true);
            }
            finally {
                JGR.getREngine().unlock(n);
            }
        }
        return rEXP;
    }

    public static REXP eval(String string) throws REngineException, REXPMismatchException {
        if (JGR.getREngine() == null) {
            throw new REngineException(null, "REngine not available");
        }
        REXP rEXP = JGR.getREngine().parseAndEval(string, null, true);
        return rEXP;
    }

    public static void threadedEval(String string) {
        final String string2 = string;
        new Thread(new Runnable(){

            public void run() {
                try {
                    JGR.eval(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    public static REXP timedEval(String string) {
        return JGR.timedEval(string, 15000, true);
    }

    public static REXP timedEval(String string, boolean bl) {
        return JGR.timedEval(string, 15000, bl);
    }

    public static REXP timedEval(String string, int n, boolean bl) {
        return new MonitoredEval(n, bl).run(string);
    }

    public static void timedAssign(String string, REXP rEXP) {
        JGR.timedAssign(string, rEXP, 15000, true);
    }

    public static void timedAssign(String string, REXP rEXP, boolean bl) {
        JGR.timedAssign(string, rEXP, 15000, bl);
    }

    public static void timedAssign(String string, REXP rEXP, int n, boolean bl) {
        new MonitoredEval(n, bl).assign(string, rEXP);
    }

    public static REngine getREngine() {
        return rEngine;
    }

    public static void setREngine(REngine rEngine) {
        JGR.rEngine = rEngine;
    }

    public static String exit() {
        int n = 1;
        if (JGRPrefs.askForSavingWorkspace) {
            n = JOptionPane.showConfirmDialog(null, "Save workspace?", "Close JGR", 1, 3);
        }
        if (n == 0) {
            JGR.writeHistory();
            JGRPrefs.writeCurrentPackagesWhenExit();
            return "y\n";
        }
        if (n == 1) {
            JGRPrefs.writeCurrentPackagesWhenExit();
            return "n\n";
        }
        return "c\n";
    }

    public static void addMenu(String string) {
        if (MAINRCONSOLE == null) {
            return;
        }
        EzMenuSwing.addMenu((JFrame)((Object)MAINRCONSOLE), (String)string);
    }

    public static void insertMenu(String string, int n) {
        if (MAINRCONSOLE == null) {
            return;
        }
        JGR.insertMenu((JFrame)((Object)MAINRCONSOLE), string, n);
    }

    private static void insertMenu(JFrame jFrame, String string, int n) {
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        JMenu jMenu = EzMenuSwing.getMenu((JFrame)jFrame, (String)string);
        if (jMenu == null && n < jMenuBar.getMenuCount()) {
            JMenuBar jMenuBar2 = new JMenuBar();
            int n2 = jMenuBar.getMenuCount();
            for (int i = 0; i < n2; ++i) {
                if (i == n) {
                    jMenuBar2.add(new JMenu(string));
                }
                jMenuBar2.add(jMenuBar.getMenu(0));
            }
            jFrame.setJMenuBar(jMenuBar2);
        } else if (jMenu == null && n == jMenuBar.getMenuCount()) {
            EzMenuSwing.addMenu((JFrame)jFrame, (String)string);
        }
    }

    public static void addMenuItem(String string, String string2, String string3, boolean bl) {
        if (MAINRCONSOLE == null) {
            return;
        }
        JGRListener jGRListener = new JGRListener(bl);
        EzMenuSwing.addJMenuItem((JFrame)((Object)MAINRCONSOLE), (String)string, (String)string2, (String)string3, (ActionListener)jGRListener);
    }

    public static void addMenuItem(String string, String string2, String string3) {
        JGR.addMenuItem(string, string2, string3, true);
    }

    public static void addMenuSeparator(String string) {
        if (MAINRCONSOLE == null) {
            return;
        }
        EzMenuSwing.addMenuSeparator((JFrame)((Object)MAINRCONSOLE), (String)string);
    }

    public static void insertMenuSeparator(String string, int n) {
        if (MAINRCONSOLE == null) {
            return;
        }
        JMenu jMenu = EzMenuSwing.getMenu((JFrame)((Object)MAINRCONSOLE), (String)string);
        jMenu.insertSeparator(n);
    }

    public static void insertMenuItem(String string, String string2, String string3, boolean bl, int n) {
        if (MAINRCONSOLE == null) {
            return;
        }
        JGRListener jGRListener = new JGRListener(bl);
        JGR.insertJMenuItem((JFrame)((Object)MAINRCONSOLE), string, string2, string3, jGRListener, n);
    }

    private static void insertJMenuItem(JFrame jFrame, String string, String string2, String string3, ActionListener actionListener, int n) {
        JMenu jMenu = EzMenuSwing.getMenu((JFrame)jFrame, (String)string);
        JMenuItem jMenuItem = new JMenuItem(string2);
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setActionCommand(string3);
        jMenu.insert(jMenuItem, n);
    }

    public static void insertMenuItem(String string, String string2, String string3, int n) {
        JGR.insertMenuItem(string, string2, string3, true, n);
    }

    public static String[] getMenuNames() {
        if (MAINRCONSOLE == null) {
            return new String[0];
        }
        JMenuBar jMenuBar = MAINRCONSOLE.getJMenuBar();
        String[] stringArray = new String[jMenuBar.getMenuCount()];
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            stringArray[i] = jMenuBar.getMenu(i).getText();
        }
        return stringArray;
    }

    public static String[] getMenuItemNames(String string) {
        if (MAINRCONSOLE == null) {
            return new String[0];
        }
        JMenu jMenu = EzMenuSwing.getMenu((JFrame)((Object)MAINRCONSOLE), (String)string);
        String[] stringArray = new String[jMenu.getItemCount()];
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            stringArray[i] = jMenu.getItem(i) != null ? jMenu.getItem(i).getText() : "-";
        }
        return stringArray;
    }

    public static void removeMenu(int n) {
        if (MAINRCONSOLE == null) {
            return;
        }
        MAINRCONSOLE.getJMenuBar().remove(n);
    }

    public static void removeMenu(String string) {
        String[] stringArray = JGR.getMenuNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            MAINRCONSOLE.remove(i);
        }
    }

    public static void removeMenuItem(String string, int n) {
        JMenu jMenu = EzMenuSwing.getMenu((JFrame)((Object)MAINRCONSOLE), (String)string);
        jMenu.remove(n);
    }

    public static void removeMenuItem(String string, String string2) {
        JMenu jMenu = EzMenuSwing.getMenu((JFrame)((Object)MAINRCONSOLE), (String)string);
        String[] stringArray = JGR.getMenuItemNames(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            jMenu.remove(i);
        }
    }

    public static void insertSubMenu(String string, String string2, int n, String[] stringArray, String[] stringArray2) {
        JMenu jMenu = new JMenu(string2);
        jMenu.setMnemonic(83);
        for (int i = 0; i < stringArray.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setText(stringArray[i]);
            jMenuItem.setActionCommand(stringArray2[i]);
            jMenuItem.addActionListener(new JGRListener(true));
            jMenu.add(jMenuItem);
        }
        JMenu jMenu2 = EzMenuSwing.getMenu((JFrame)((Object)MAINRCONSOLE), (String)string);
        jMenu2.insert(jMenu, n);
    }

    public static void addSubMenu(String string, String string2, String[] stringArray, String[] stringArray2) {
        JMenu jMenu = new JMenu(string2);
        jMenu.setMnemonic(83);
        for (int i = 0; i < stringArray.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setText(stringArray[i]);
            jMenuItem.setActionCommand(stringArray2[i]);
            jMenuItem.addActionListener(new JGRListener(true));
            jMenu.add(jMenuItem);
        }
        JMenu jMenu2 = EzMenuSwing.getMenu((JFrame)((Object)MAINRCONSOLE), (String)string);
        jMenu2.add(jMenu);
    }

    public static void setRHome(String string) {
        RHOME = string;
    }

    public static void setKeyWords(String string) {
        JGR.setKeyWords(new String[]{string});
    }

    public static void setKeyWords(String[] stringArray) {
        KEYWORDS.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            KEYWORDS.add(stringArray[i]);
        }
    }

    public static void setObjects(String string) {
        JGR.setObjects(new String[]{string});
    }

    public static void setObjects(String[] stringArray) {
        OBJECTS.clear();
        KEYWORDS_OBJECTS.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("tempMatrixContentJGR".equals(string) || "tempMatrixDimNamesJGR".equals(string) || "jgrtemp".equals(string)) continue;
            KEYWORDS_OBJECTS.add(string);
            OBJECTS.add(string);
        }
    }

    public static void readHistory() {
        File file = null;
        try {
            tempWD = JGRPrefs.workingDirectory;
            file = new File(JGRPrefs.workingDirectory + File.separator + ".JGRhistory");
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                RHISTORY = new Vector();
                String string = null;
                while (bufferedReader.ready()) {
                    if (!(string = (string == null ? "" : string + "\n") + bufferedReader.readLine()).endsWith("#")) continue;
                    RHISTORY.add(string.substring(0, string.length() - 1));
                    string = null;
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public static void writeHistory() {
        File file = null;
        try {
            file = new File(tempWD + File.separator + ".JGRhistory");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            Enumeration enumeration = RHISTORY.elements();
            while (enumeration.hasMoreElements()) {
                bufferedWriter.write(enumeration.nextElement().toString() + "#\n");
                bufferedWriter.flush();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public static boolean isJGRmain() {
        return JGRmain;
    }

    private void checkForMissingPkg() {
        try {
            String string = JGRPrefs.previousPackages;
            if (string == null) {
                return;
            }
            String string2 = RController.getCurrentPackages();
            if (string2 == null) {
                return;
            }
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken().toString().replaceFirst(",", ""));
            }
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector2.add(stringTokenizer.nextToken().toString().replaceFirst(",", ""));
            }
            for (int i = 0; i < vector.size(); ++i) {
                vector2.remove(vector.elementAt(i));
            }
            if (vector2.size() > 0) {
                new JGRPackageManager(vector2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        JGRmain = true;
        arguments = stringArray;
        if (stringArray.length > 0) {
            object = new Vector();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("--debug")) {
                    Global.DEBUG = 1;
                    Rengine.DEBUG = 1;
                    System.out.println("JGR version 1.7-18");
                } else {
                    ((Vector)object).add(stringArray[i]);
                }
                if (stringArray[i].equals("--version")) {
                    System.out.println("JGR version 1.7-18");
                    System.exit(0);
                }
                if (stringArray[i].equals("--help") || stringArray[i].equals("-h")) {
                    System.out.println("JGR version 1.7-18");
                    System.out.println("\nOptions:");
                    System.out.println("\n\t-h, --help\t Print short helpmessage and exit");
                    System.out.println("\t--version\t Print version end exit");
                    System.out.println("\t--debug\t Print more information about JGR's process");
                    System.out.println("\nMost other R options are supported too");
                    System.exit(0);
                }
                if (stringArray[i].startsWith("--withPackages=")) {
                    launcherPackages = stringArray[i].substring(15);
                }
                if (!stringArray[i].startsWith("--noSplash")) continue;
                showSplash = false;
            }
            Object[] objectArray = ((Vector)object).toArray();
            if (objectArray.length > 0) {
                rargs = new String[objectArray.length + 1];
                for (int i = 0; i < rargs.length - 1; ++i) {
                    JGR.rargs[i] = objectArray[i].toString();
                }
                JGR.rargs[JGR.rargs.length - 1] = "--save";
            }
        }
        if (Global.DEBUG > 0) {
            for (int i = 0; i < rargs.length; ++i) {
                System.out.println(rargs[i]);
            }
        }
        object = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel((String)object);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            new JGR();
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public static void refreshObjects() {
        try {
            REXP rEXP = JGR.idleEval("try(.refreshObjects(),silent=TRUE)");
            String[] stringArray = null;
            if (rEXP != null && (stringArray = rEXP.asStrings()) != null) {
                JGR.setObjects(stringArray);
            }
        }
        catch (REngineException rEngineException) {
            new ErrorMsg(rEngineException);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            new ErrorMsg(rEXPMismatchException);
        }
    }

    static {
        arguments = new String[0];
        rargs = new String[]{"--save"};
        JGRmain = false;
        launcherPackages = null;
        showSplash = true;
    }

    class Refresher
    implements Runnable {
        public Refresher() {
            JGR.this.checkForMissingPkg();
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                        REXP rEXP = JGR.idleEval("try(.refreshKeyWords(),silent=TRUE)");
                        String[] stringArray = null;
                        if (rEXP != null && (stringArray = rEXP.asStrings()) != null) {
                            JGR.setKeyWords(stringArray);
                        }
                        rEXP = JGR.idleEval("try(.refreshObjects(),silent=TRUE)");
                        stringArray = null;
                        if (rEXP != null && (stringArray = rEXP.asStrings()) != null) {
                            JGR.setObjects(stringArray);
                        }
                        RController.refreshObjects();
                    }
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                    continue;
                }
                break;
            }
        }
    }
}

