# Script for creating test data files.
# The aim of these files is to have reproducable tests
# so we save JSON files of the response from the server and
# then in the tests load them.

testDataFolder <- "tests/testthat/testData/"

mydsws <- dsws$new()


#  test of simple timeseries request with relative dates

mydsws$jsonResponseSaveFile <- file.path(testDataFolder, "test-dsws-timeSeriesRequest-test01.json")

xtsData <- mydsws$timeSeriesRequest(instrument = "MKS",
                                    datatype = "MV",
                                    startDate = "-30D",
                                    endDate = "-0D",
                                    frequency = "D")


# test of two stock timeseries request with relative dates

mydsws$jsonResponseSaveFile <- file.path(testDataFolder, "test-dsws-timeSeriesRequest-test02.json")

xtsData <- mydsws$timeSeriesRequest(instrument = c("MKS","RIO"),
                                    datatype = "MV",
                                    startDate = "-30D",
                                    endDate = "-0D",
                                    frequency = "D")




############################################################################################################

longListDSCodes <- c(
  "JP3735400008",	"JP3633400001",	"JP3810800007",	"JP3704800006",	"JP3589200009",	"JP3474200007",	"JP3344000009",
  "JP3762600009",	"JP3317400004",	"JP3866800000",	"JP3585800000",	"JP3788600009",	"JP3112200005",	"JP3562800007",
  "JP3900000005",	"JP3592200004",	"JP3381000003",	"JP3228600007",	"JP3435000009",	"JP3854600008",	"JP3898800002",
  "JP3502200003",	"JP3783600004",	"JP3672400003",	"JP3818000006",	"JP3898400001",	"JP3733000008",	"JP3670000003",
  "JP3526600006",	"JP3359600008",	"JP3551500006",	"JP3726800000",	"JP3405000005",	"JP3496400007",	"JP3899600005",
  "JP3242800005",	"JP3902400005",	"JP3814000000",	"JP3429800000",	"JP3463000004",	"JP3112000009",	"JP3893600001",
  "JP3249600002",	"JP3493800001",	"JP3258000003",	"JP3830800003",	"JP3605400005",	"JP3260800002",	"JP3705200008",
  "JP3224600001",	"JP3340600000",	NA,	            "JP3895800005",	"JP3404600003",	"JP3246400000",	"JP3326400003",
  "JP3111200006",	"JP3802400006",	"JP3756600007",	"JP3402200004",	"JP3210200006",	"JP3703600001",	"JP3729400006",
  "JP3573000001",	"JP3351200005",	"JP3893200000",	"JP3143600009",	"JP3629000005",	"JP3621000003",	"JP3180400008",
  "JP3266400005",	"JP3289800009",	"JP3407400005",	"JP3955400001",	"JP3420600003",	"JP3304200003",	"JP3522200009",
  "JP3358800005",	"JP3914400001",	"JP3388200002",	"JP3877600001",	"JP3401400001",	"JP3867600003",	"JP3505000004",
  "JP3119600009",	"JP3205800000",	"JP3574200006",	"JP3419400001",	"JP3421800008",	"JP3899800001",	"JP3679700009",
  "JP3626800001",	"JP3870400003",	"JP3942400007",	"JP3973400009",	"JP3443600006",	"JP3174410005",	"JP3721600009",
  "JP3442800003",	"JP3511800009",	"JP3165700000",	"JP3753000003",	"JP3371200001",	"JP3538800008",	"JP3436100006",
  "JP3932800000",	"JP3613400005",	"JP3350800003",	"JP3394200004",	"JP3769000005",	"JP3982800009",	"JP3224200000",
  "JP3903000002",	"JP3190000004",	"JP3197800000",	"JP3108600002",	"JP3571400005",	"JP3134800006",	"JP3397200001",
  "JP3634600005",	"JP3276400003",	"JP3402600005",	"JP3597800006",	"JP3389900006",	"JP3544000007",	"JP3789000001",
  "JP3194000000",	"JP3845400005",	"JP3850200001",	"JP3116000005",	"JP3137200006",	"JP3774200004",	"JP3196000008",
  "JP3596200000",	"JP3160400002",	"JP3868400007",	"JP3197600004",	"JP3657400002",	"JP3833750007",	"JP3351600006",
  "JP3894800006",	"JP3162600005",	"JP3786200000",	"JP3940000007",	"JP3263000006",	"JP3256000005",	"JP3166000004",
  "JP3720800006",	"JP3676000007",	"JP3935600001",	"JP3865600005",	"JP3476600006",	"JP3661000004",	"JP3294400001",
  "JP3674000009",	"JP3901600001",	"JP3102000001",	"JP3837800006",	"JP3493400000",	"JP3802600001",	"JP3117600001",
  "JP3236200006",	"JP3277800003",	"JP3693200002",	"JP3780200006",	"JP3732200005",	"JP3122400009",	"JP3362700001",
  "JP3695200000",	"JP3949600005",	"JP3820000002",	"JP3942600002",	"JP3352000008",	"JP3389500004",	"JP3428600005",
  "JP3456000003",	"JP3521000004",	"JP3366800005",	"JP3743000006",	"JP3906000009",	"JP3935200000",	"JP3662000003",
  "JP3368000000",	"JP3449020001",	"JP3172500005",	"JP3269600007",	"JP3158800007",	"JP3700000007",	"JP3297000006",
  "JP3243600008",	"JP3298600002",	"JP3675600005",	"JP3792600003",	"JP3659200004",	"JP3892000005",	"JP3270000007",
  "JP3165600002",	"JP3320800000",	"JP3122800000",	"JP3650600004",	"JP3280200001",	"JP3347200002",	"JP3271400008",
  "JP3587600002",	"JP3834200002",	"JP3676800000",	"JP3579800008",	"JP3627000007",	"JP3733400000",	"JP3539250005",
  "JP3870000001",	"JP3140000005",	"JP3588600001",	"JP3409800004",	"JP3417400003",	"JP3326410002",	"JP3790600005",
  "JP3373800006",	"JP3409000001",	"JP3902000003",	"JP3598600009",	"JP3266800006",	"JP3209000003",	"JP3200450009",
  "JP3340000003",	"JP3398000004",	"JP3851400006",	"JP3595200001",	"JP3888300005",	"JP3201200007",	"JP3358000002",
  "JP3862400003",	"JP3459600007",	"JP3774600005",	"JP3227200007",	"JP3230600003",	"JP3300600008",	"JP3496600002",
  "JP3352400000",	"JP3309000002",	"JP3816800001",	"JP3481800005",	"JP3219000001",	"JP3738600000",	"JP3619800000",
  "JP3415400005",	"JP3903600009",	"JP3553600002",	"JP3955000009",	"JP3278600006",	"JP3824400000",	"JP3519400000",
  "JP3356500003",	"JP3917000006",	"JP3816700003",	"JP3814800003",	"JP3717200004",	"JP3931600005",	"JP3786600001",
  "JP3891600003",	"JP3896800004",	"JP3947600007",	"JP3215800008",	"JP3194800003",	"JP3145600007",	"JP3854200007",
  "JP3203500008",	"JP3811000003",	"JP3725000008",	"JP3405400007",	"JP3678000005",	"JP3684000007",	"JP3400900001",
  "JP3924800000",	"JP3106200003",	"JP3992800007",	"JP3491000000",	"JP3528600004",	"JP3942800008",	"JP3715200006",
  "JP3485800001",	"JP3686800008",	"JP3305800009",	"JP3665200006",	"JP3223800008",	"JP3901200000",	"JP3667600005",
  "JP3799000009",	"JP3888400003",	"JP3199000005",	"JP3126400005",	"JP3430400006",	"JP3750200002",	"JP3285400002",
  "JP3600200004",	"JP3992400006",	"JP3569000007",	"JP3765400001",	"JP3953400003",	"JP3778600001",	"JP3649800004",
  "JP3844200000",	"JP3653000004",	"JP3658000009",	"JP3806800003",	"JP3785000005",	"JP3922800002",	"JP3546800008",
  "JP3865200004",	"JP3344400001",	"JP3149600003",	"JP3783800000",	"JP3716400001",	"JP3797000001",	"JP3362600003",
  "JP3251200006",	"JP3791800000",	"JP3835620000",	"JP3524000001",	"JP3486800000",	"JP3139200004",	"JP3396200002",
  "JP3217100001",	"JP3955800002",	"JP3336000009",	"JP3781600006",	"JP3751800008",	"JP3469000008",	"JP3176000002",
  "JP3714400003",	"JP3397080007",	"JP3346400009",	"JP3392600007",	"JP3292200007",	"JP3385980002",	"JP3285000000",
  "JP3835600002",	"JP3483800003",	"JP3463200000",	"JP3917800009",	"JP3783420007",	"JP3906800002",	"JP3495000006",
  "JP3540400003",	"JP3871200006",	"JP3128800004",	"JP3951600000",	"JP3787000003",	"JP3411000007",	"JP3793800008",
  "JP3404400008",	"JP3404200002",	"JP3663600009",	"JP3452000007",	"JP3156400008", "JP3409400003",	"JP3375800004",
  "JP3759500006",	"JP3794200000",	"JP3942000005",	"JP3651200002",	"JP3279400000",	"JP3148800000",	"JP3571800006",
  "JP3809200003",	"JP3659000008",	"JP3198900007",	"JP3937200008",	"JP3707900001",	"JP3494600004",	"JP3593400009",
  "JP3294600006",	"JP3788800005",	"JP3497400006",	"JP3990200002",	"JP3633800002",	"JP3152400002",	"JP3324000003",
  "JP3484200005",	"JP3542800002",	"JP3350000000",	"JP3601000007",	"JP3648800005",	"JP3919200000",	"JP3959400007",
  "JP3240400006",	"JP3121600005",	"JP3300200007",	"JP3579000005",	"JP3977200009",	"JP3726200003",	"JP3661800007",
  "JP3734800000",	"JP3819400007",	"JP3105040004",	"JP3408600009",	"JP3613000003",	"JP3356800007",	"JP3143000002",
  "JP3277230003",	"JP3161200005",	"JP3580200008",	"JP3904400003",	"JP3694400007",	"JP3763000001",	"JP3816600005",
  "JP3124400007",	"JP3976300008",	"JP3549600009",	"JP3711600001",	"JP3869000004",	"JP3638600001",	"JP3254200003",
  "JP3883200002",	"JP3830000000",	"JP3845800006",	"JP3594000006",	"JP3629200001",	"JP3337600005",	"JP3336400001",
  "JP3892400007",	"JP3329600005",	"JP3950600001",	"JP3733800001",	"JP3932000007",	"JP3841800000",	"JP3343200006",
  "JP3591000009",	"JP3862800004",	"JP3635700002",	"JP3109800007",	"JP3670800006",	"JP3684400009",	"JP3771800004",
  "JP3921100008",	"JP3566800003",	"JP3258200009",	"JP3155380003",	"JP3725400000",	"JP3818400008",	"JP3358200008",
  "JP3131400008",	"JP3965400009",	"JP3281800007",	"JP3172100004",	"JP3112400001",	"JP3952000002",	"JP3269200006",
  "JP3449100001",	"JP3660400007",	"JP3599000001",	"JP3221400009",	"JP3896000001",	"JP3710000005",	"JP3448400006",
  "JP3445200003",	"JP3135200008",	"JP3188000008",	"JP3293200006",	"JP3754200008",	"JP3244800003",	"JP3742600004",
  "JP3612800007",	"JP3400400002",	"JP3164800009",	"JP3712600000",	"JP3126130008",	"JP3933800009",	"JP3637300009",
  "JP3315000004",	"JP3357200009",	"JP3214300000",	"JP3882600004",	"JP3660900006",	"JP3165650007",	"JP3802670004",
  "JP3639650005",	"JP3802300008",	"JP3173400007",	"JP3548600000",	"JP3160950006",	"JP3306800008",	"JP3689500001",
  "JP3634200004",	"JP3164630000",	"JP3825850005",	"JP3322600002",	"JP3388550000",	"JP3371930003",	"JP3218900003",
  "JP3422100002",	"JP3310500008",	"JP3328500008",	"JP3976000004",	"JP3436150001",	"JP3944130008",	"JP3301100008",
  "JP3788000002",	"JP3966800009",	"JP3167480007",	"JP3939000000",	"JP3143900003",	"JP3748500000",	"JP3352200004",
  "JP3758200004",	"JP3126330004",	"JP3388450003",	"JP3885400006",	"JP3254100005",	"JP3273700009",	"JP3826200002",
  "JP3152800003",	"JP3551550001",	"JP3801550009",	"JP3993900004",	"JP3152750000",	"JP3190800007",	"JP3967200001",
  "JP3827200001",	"JP3173500004",	"JP3480200009",	"JP3862950007",	"JP3738400005",	"JP3399400005",	"JP3982100004",
  "JP3414870000",	"JP3386150001",	"JP3188200004",	"JP3311500007",	"JP3395900008",	"JP3429000007",	"JP3784600003",
  "JP3214200002",	"JP3436120004",	"JP3217000003",	"JP3754300006",	"JP3902900004",	"JP3944300007",	"JP3638200000",
  "JP3551530003",	"JP3750500005",	"JP3103600007",	"JP3835900006",	"JP3283650004",	"JP3863800003",	"JP3833700002",
  "JP3551520004",	"JP3425000001",	"JP3762800005",	"JP3500610005",	"JP3104850007",	"JP3678800008",	"JP3892100003",
  "JP3977400005",	"JP3305600003",	"JP3910660004",	"JP3958000006",	"JP3535600005",	"JP3386030005",	"JP3379550001",
  "JP3499800005",	"JP3286000009",	"JP3673600007",	"JP3705400004",	"JP3431900004",	"JP3635000007",	"JP3379900008",
  "JP3268950007",	"JP3164710000",	"JP3890350006",	"JP3885780001",	"JP3564200008",	"JP3414750004",	"JP3164720009",
  "JP3426800003",	"JP3894810005",	"JP3842400008",	"JP3756100008",	"JP3802680003",	"JP3567410000",	"JP3946700006",
  "JP3421100003",	"JP3220400000",	"JP3729000004",	"JP3153300003",	"JP3167500002",	"JP3399900004",	"JP3833180007",
  "JP3108060009",	"JP3320950003",	"JP3539220008",	"JP3480400005",	"JP3154000008",	"JP3749380006",	"JP3802810006",
  "JP3916000007",	"JP3126340003",	"JP3869970008",	"JP3310100007",	"JP3419050004",	"JP3635400009",	"JP3551200003",
  "JP3633000009",	"JP3294430008",	"JP3167640006",	"JP3165690003",	"JP3131430005",	"JP3130780004",	"JP3766550002",
  "JP3392750000",	"JP3235900002",	"JP3422950000",	"JP3475350009",	"JP3778630008",	"JP3776200002",	"JP3897700005",
  "JP3768600003",	"JP3625000009",	"JP3322930003",	"JP3601800000",	"JP3407200009",	"JP3100180003",	"JP3327600007",
  "JP3674410000",	"JP3218850000",	"JP3582600007",	"JP3164620001",	"JP3294460005",	"JP3762900003",	"JP3142500002",
  "JP3935300008",	"JP3711200000",	"JP3457000002",	"JP3721400004",	"JP3663900003",	"JP3805010000",	"JP3448000004",
  "JP3940400009",	"JP3386380004",	"JP3118000003",	"JP3435350008",	"JP3548610009",	"JP3566600007",	"JP3105220002",
  "JP3578800009",	"JP3890310000",	"JP3894900004",	"JP3560800009",	"JP3713200008",	"JP3160670000",	"JP3351100007",
  "JP3152740001",	"JP3535800001",	"JP3316400005",	"JP3385820000",	"JP3981400009",	"JP3220500007",	"JP3138400001",
  "JP3336600006",	"JP3207800008",	"JP3918000005",	"JP3284600008",	"JP3274070006",	"JP3132600002",	"JP3229400001",
  "JP3476480003",	"JP3386450005",	"JP3165000005",	"JP3130100005",	"JP3651210001",	"JP3188220002",	"JP3311400000",
  "JP3277150003",	"JP3399310006",	"JP3822000000",	"JP3435750009",	"JP3206000006",	"JP3442850008",	"JP3758190007",
  "JP3794540009",	"JP3780100008",	"JP3749400002",	"JP3360800001",	"JP3220580009",	"JP3208200000",	"JP3397060009",
  "JP3791200003",	"JP3705200008",	"JP3845770001",	"JP3424950008",	"JP3122550001",	"JP3183200009",	"JP3298400007",
  "JP3460200003",	"JP3142350002",	"JP3336560002",	"JP3305960001",	"JP3672000001",	"JP3539230007",	"JP3569200003",
  "JP3131090007",	"JP3577600004",	"JP3293300004",	"JP3491910000",	"JP3389660006",	"JP3417200007",	"JP3882750007",
  "JP3699400002",	"JP3311530004",	"JP3305530002",	"JP3970300004",	"JP3536150000",	"JP3610600003",	"JP3801600002",
  "JP3207000005",	"JP3855900001",	"JP3922950005",	"JP3547670004")

mydsws <- dsws$new()
mydsws$jsonResponseSaveFile <- file.path(testDataFolder, "test-dsws-timeSeriesRequestChunking-test01.json")
xtsData <- mydsws$timeSeriesRequest(instrument = longListDSCodes,
                                    expression = "(XXXX(SAL1FD12)/XXXX(SAL1TR12))-1.00",
                                    startDate = as.Date("1996-01-01"),
                                    endDate = as.Date("2016-01-20"),
                                    frequency = "M")
