% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema_conf.R
\name{default_simulation_params}
\alias{default_simulation_params}
\alias{opt_default_character}
\alias{opt_default_numeric}
\alias{opt_default_integer}
\alias{opt_default_logical}
\alias{opt_default_date}
\title{Setup default column type parameters}
\usage{
opt_default_character(
  regexp = "text|char|factor",
  nchar = 10,
  na_ratio = 0.05,
  not_null = FALSE,
  unique = FALSE,
  default = "",
  levels_ratio = 1,
  ...
)

opt_default_numeric(
  regexp = "^decimal|^numeric|real|double precision",
  na_ratio = 0.05,
  not_null = FALSE,
  unique = FALSE,
  default = 0,
  precision = 7,
  scale = 2,
  levels_ratio = 1,
  ...
)

opt_default_integer(
  regexp = "smallint|integer|bigint|smallserial|serial|bigserial",
  na_ratio = 0.05,
  not_null = FALSE,
  unique = FALSE,
  default = "",
  levels_ratio = 1,
  ...
)

opt_default_logical(
  regexp = "boolean|logical",
  na_ratio = 0.05,
  not_null = FALSE,
  unique = FALSE,
  default = FALSE,
  levels_ratio = 1,
  ...
)

opt_default_date(
  regexp = "date|Date",
  na_ratio = 0.05,
  not_null = FALSE,
  unique = FALSE,
  default = Sys.Date(),
  format = "\%Y-\%m-\%d",
  min_date = as.Date("1970-01-01"),
  max_date = Sys.Date(),
  levels_ratio = 1,
  ...
)
}
\arguments{
\item{regexp}{Regular expression that allows mapping YAML configuration column
type to desired R class.}

\item{nchar}{Maximum number of characters when simulating character values.
When source column is of type \code{char(n)} the parameter is ignored.}

\item{na_ratio}{Ratio of NA values returned in simulated sample.}

\item{not_null}{Should the column allow to simulate NA values?}

\item{unique}{Should column values be unique?}

\item{default}{Default column value. Ignored during simulation.}

\item{levels_ratio}{Ratio of unique values (in terms of sample length) simulated in the sample.}

\item{...}{Other default parameters attached to the column definition.}

\item{precision}{Precision of numeric column value when simulating numeric values.
When source column is of type e.g. \code{numeric(precision)} the parameter is ignored.}

\item{scale}{Precision of numeric column value when simulating numeric values.
When source column is of type e.g. \code{numeric(precision, scale)} the parameter is ignored.}

\item{format}{Format of date used when simulating Date columns.}

\item{min_date, max_date}{Minimum and maximum date used when simulating Date columns.}
}
\description{
All the parameters (excluding \code{regexp}) are attached to column definition
when the ones are not specified in configuration YAML file.
All the functions are used to specify default configuration
(see: \code{\link{default_faker_opts}}).
}
