% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_histogram.r
\name{plot_histogram}
\alias{plot_histogram}
\title{Plot histogram}
\usage{
plot_histogram(
  data,
  binary_as_factor = TRUE,
  geom_histogram_args = list(bins = 30L),
  scale_x = "continuous",
  title = NULL,
  ggtheme = theme_gray(),
  theme_config = list(),
  nrow = 4L,
  ncol = 4L,
  parallel = FALSE
)
}
\arguments{
\item{data}{input data}

\item{binary_as_factor}{treat binary as categorical? Default is \code{TRUE}.}

\item{geom_histogram_args}{a list of other arguments to \link{geom_histogram}}

\item{scale_x}{scale of x axis. See \link{scale_x_continuous} for all options. Default is \code{continuous}.}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. The default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}.}

\item{nrow}{number of rows per page. Default is 4.}

\item{ncol}{number of columns per page. Default is 4.}

\item{parallel}{enable parallel? Default is \code{FALSE}.}
}
\value{
invisibly return the named list of ggplot objects
}
\description{
Plot histogram for each continuous feature
}
\examples{
# Plot iris data
plot_histogram(iris, ncol = 2L)

# Plot skewed data on log scale
set.seed(1)
skew <- data.frame(replicate(4L, rbeta(1000, 1, 5000)))
plot_histogram(skew, ncol = 2L)
plot_histogram(skew, scale_x = "log10", ncol = 2L)
}
\seealso{
\link{geom_histogram} \link{plot_density}
}
\keyword{plot_histogram}
