% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chp3.R
\name{Chapter03}
\alias{Chapter03}
\alias{addProbs}
\alias{predictive_value}
\title{Chapter 3}
\usage{
addProbs(A)

predictive_value(
  A,
  sensitivity = A[1, 1]/sum(A[, 1]),
  specificity = A[2, 2]/sum(A[, 2]),
  prevalence = stop("must provide prevalence")
)
}
\arguments{
\item{A}{\link[base]{integer} \link[base]{matrix} of contingency table.
For \link{predictive_value} function, this must be a 2-by-2 contingency table.}

\item{sensitivity}{\link[base]{numeric} scalar, sensitivity of a test}

\item{specificity}{\link[base]{numeric} scalar, specificity of a test}

\item{prevalence}{(optional) \link[base]{numeric} scalar, prevalence of a disease}
}
\value{
\link{addProbs} returns an \code{'addProbs'} object.

\link{predictive_value} returns a \code{'predictiveValue'} object.
}
\description{
Functions for Chapter 3, \emph{Some Basic Probability Concepts}.
}
\details{
\link{addProbs} provides the joint, marginal and conditional probabilities of a contingency table.
\link{predictive_value} provides the predictive values based on (the sensitivity and specificity of) a test, 
based on the 2-by-2 test-disease contingency table,
and the disease prevalence.
}
\examples{
library(DanielBiostatistics10th)
# To run a line of code, use shortcut
# Command + Enter: Mac and RStudio Cloud
# Control + Enter: Windows, Mac and RStudio Cloud
# To clear the console
# Control + L: Mac and RStudio Cloud

# To view the help files of functions in Chapter 3
# ?Chp3

# Page 69, Example 3.4.1
(d341 = matrix(c(28L, 19L, 41L, 53L, 35L, 38L, 44L, 60L), ncol = 2L, 
 dimnames = list(
   FamilyHx = c('none', 'Bipolar', 'Unipolar', 'UniBipolar'), 
   Onset = c('Early', 'Late'))))
class(d341) # 'matrix', i.e., a two-dimensional array
addProbs(d341)

# Page 81, Example 3.5.1
(d351 = matrix(c(436L, 14L, 5L, 495L), nrow = 2L, 
  dimnames = list(Test = c('Positive', 'Negative'), Alzheimer = c('Yes', 'No'))))
predictive_value(d351, prevalence = .113)
}
\references{
Wayne W. Daniel, \emph{Biostatistics: A Foundation for Analysis in the Health Sciences}, Tenth Edition.
Wiley, ISBN: 978-1-119-62550-6.
}
\seealso{
\link[stats]{addmargins} \link[base]{rowSums} \link[base]{colSums} \link[base]{proportions}
}
