% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chp9.R
\name{Chapter09}
\alias{Chapter09}
\alias{predict_lm}
\title{Chapter 9}
\usage{
predict_lm(object, newx, level = 0.95, ...)
}
\arguments{
\item{object}{\link[stats]{lm} object, with one and only one \link[base]{numeric} predictor}

\item{newx}{(optional) \link[base]{numeric} scalar or vector, new \eqn{x}-value(s) for which the fitted response(s) are to be reported}

\item{level}{\link[base]{numeric} scalar, tolerance/confidence level, default .95}

\item{...}{potential arguments, not in use currently}
}
\value{
Function \link{predict_lm} returns a \code{'predict_lm'} object, for which
a \link[base]{print} method, an \link[ggplot2]{autolayer} and an \link[ggplot2]{autoplot} method are defined.
}
\description{
Functions for Chapter 9, \emph{Simple Linear Regression and Correlation}.
}
\examples{
library(DanielBiostatistics10th)

# Page 417, Example 9.3.1
head(EXA_C09_S03_01)
names(EXA_C09_S03_01)[2:3] = c('Waist', 'AT')
plot(AT ~ Waist, data = EXA_C09_S03_01, xlab = 'Waist circumference (cm), X', 
     ylab = 'Deep abdominal AT area (cm2), Y', main = 'Page 419, Figure 9.3.1')

# Page 436, Example 9.4.2
summary(m931 <- lm(AT ~ Waist, data = EXA_C09_S03_01))
cor(EXA_C09_S03_01[2:3]); cor.test(~ AT + Waist, data = EXA_C09_S03_01)
confint(m931) # confidence interval of regression coefficients
anova(m931)

# Page 440, Example 9.4.3
plot(m931, which = 1, main = 'Page 440, Figure 9.4.8')

# Page 441, Section 9.5
autoplot(predict_lm(m931)) + labs(
  xlab = 'Waist circumference (cm), X', 
  ylab = 'Deep abdominal AT area (cm2), Y',
  title = 'Page 422, Figure 9.3.3; Page 442, Figure 9.5.1')

# Page 447, Example 9.7.1
head(EXA_C09_S07_01)
summary(mod_971 <- lm(CV ~ HEIGHT, data = EXA_C09_S07_01))
autoplot(predict_lm(mod_971)) + labs(
  xlab = 'Height (cm)', ylab = 'Cv (units)', 
  title = 'Page 449, Figure 9.7.2')

# Page 452, Example 9.7.2
cor(EXA_C09_S07_01); cor.test(~ CV + HEIGHT, data = EXA_C09_S07_01) 
# Page 451, Figure 9.7.4, Figure 9.7.5

# Page 453, When the Hypothesized rho Is a Nonzero Value
# R does not have a function to do this

}
\seealso{
\link[stats]{predict.lm}
}
