% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{getCol.DTSg}
\alias{getCol.DTSg}
\alias{getCol}
\title{Get Column Vector}
\usage{
\method{getCol}{DTSg}(x, col = self$cols(class = "numeric"), ...)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{col}{A character string specifying a column name.}

\item{\dots}{Not used (S3 method only).}
}
\value{
Returns a vector.
}
\description{
Queries the values of a column of a \code{\link{DTSg}} object.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# get values of "flow" column
## R6 method
x$getCol(col = "flow")

## S3 method
getCol(x = x, col = "flow")

}
\seealso{
\code{\link{DTSg}}
}
