% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{colapply.DTSg}
\alias{colapply.DTSg}
\alias{colapply}
\title{Apply Function Columnwise}
\usage{
\method{colapply}{DTSg}(
  x,
  fun,
  ...,
  cols = self$cols(class = "numeric")[1L],
  clone = getOption("DTSgClone"),
  resultCols = NULL,
  suffix = NULL
)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{fun}{A function. Its return value must be of length one.}

\item{\dots}{Further arguments passed on to \code{fun}.}

\item{cols}{A character vector specifying the columns to apply \code{fun} to.}

\item{clone}{A logical specifying if the object is modified in place or if a
clone (copy) is made beforehand.}

\item{resultCols}{An optional character vector of the same length as
\code{cols}. Non-existing columns specified in this argument are added and
existing columns are overwritten by the return values of \code{fun}. Columns
are matched elementwise between \code{resultCols} and \code{cols}.}

\item{suffix}{An optional character string. The return values of \code{fun}
are added as new columns with names consisting of the columns specified in
\code{cols} and this suffix. Existing columns are never overwritten. Only
used when \code{resultCols} is not specified.}
}
\value{
Returns a \code{\link{DTSg}} object.
}
\description{
Applies an arbritary function to selected columns of a \code{\link{DTSg}}
 object.
}
\details{
In addition to the \code{\dots} argument, this method hands over a
 \code{\link{list}} argument with helper data called \code{.helpers} to
 \code{fun}. \code{.helpers} contains the following named elements:
 \itemize{
   \item \emph{.dateTime:} A \code{\link{POSIXct}} vector containing the
     \emph{.dateTime} column.
   \item \emph{periodicity:} Same as \emph{periodicity} field. See
     \code{\link{DTSg}} for further information.
   \item \emph{minLag:} A \code{\link{difftime}} object containing the
     minimum time difference between two subsequent timestamps.
   \item \emph{maxLag:} A \code{\link{difftime}} object containing the
     maximum time difference between two subsequent timestamps.
 }
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# linear interpolation of missing values
## R6 method
x$colapply(fun = interpolateLinear)

## S3 method
colapply(x = x, fun = interpolateLinear)

}
\seealso{
\code{\link{DTSg}}, \code{\link{cols}}, \code{\link{list}},
\code{\link{POSIXct}}, \code{\link{difftime}},
\code{\link{interpolateLinear}}
}
