% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{predict.DTR.Boots.KernSmooth}
\alias{predict.DTR.Boots.KernSmooth}
\title{Predict the optimal treatment given a 'DTR.Boots.KernSmooth' object}
\usage{
\method{predict}{DTR.Boots.KernSmooth}(object, newX, ...)
}
\arguments{
\item{object}{Fitted "DTR.Boots.KernSmooth" model object.}

\item{newX}{Matrix of new values for X at which predictions are to be made.}

\item{...}{Not used. Other arguments to predict.}
}
\value{
A vector of predicted optimal treatments for the new subjects given
the fitted DTR.Boots.KernSmooth model.
}
\description{
This function predicts the optimal treatments for new subjects
from a fitted DTR.Boots.KernSmooth model.
}
\details{
All the predicted optimal treatments are labeled as \{0,1\}.
}
\examples{
n <- 5e3; p <- 3
beta <- c(0.2,1,-0.5,-0.8)
beta1 <- c(1,-0.5,-0.5,0.5)

X <- matrix(rnorm(n*p),n)
a <- rbinom(n,1,0.5)
mean1 <- exp(cbind(1,X) \%*\% beta1)
mean2 <- 8/(1 + exp(-cbind(1,X) \%*\% beta)) - 4
y <- mean1 + a * mean2 + rnorm(n)

boots_smooth_model <- DTR.Boots.KernSmooth(X, y, a)
newX <- matrix(rnorm(n*p),n)
predict(boots_smooth_model, newX)

}
\references{
Wu, Y. and Wang, L. (2021),
\emph{Resampling-based Confidence Intervals for Model-free Robust Inference
on Optimal Treatment Regimes, Biometrics, 77: 465– 476}, \doi{10.1111/biom.13337}.
}
\seealso{
\code{\link{predict.DTR.KernSmooth}}, \code{\link{DTR.KernSmooth}},
\code{\link{DTR.Boots.KernSmooth}}
}
\author{
Yunan Wu and Lan Wang\cr Maintainer:
Yunan Wu <yunan.wu@utdallas.edu>
}
