% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComparePCurve.R
\name{ComparePCurve}
\alias{ComparePCurve}
\title{Power curve comparison}
\usage{
ComparePCurve(
  data,
  xCol,
  xCol.circ = NULL,
  yCol,
  testCol,
  testSet = NULL,
  thrs = 0.2,
  conflevel = 0.95,
  gridSize = c(50, 50),
  powerbins = 15,
  baseline = 1,
  limitMemory = TRUE,
  opt_method = "nlminb",
  sampleSize = list(optimSize = 500, bandSize = 5000),
  rngSeed = 1
)
}
\arguments{
\item{data}{A list of data sets to be compared, the difference in the mean function is always computed as (f(data2) - f(data1))}

\item{xCol}{A numeric or vector stating column number of covariates}

\item{xCol.circ}{A numeric or vector stating column number of circular covariates}

\item{yCol}{A numeric value stating the column number of the response}

\item{testCol}{A numeric/vector stating column number of covariates to used in generating test set. Maximum of two columns to be used.}

\item{testSet}{A matrix or dataframe consisting of test points, default value NULL, if NULL computes test points internally using testCol variables. If not NULL, total number of test points must be less than or equal to 2500.}

\item{thrs}{A numeric or vector representing threshold for each covariates}

\item{conflevel}{A numeric between (0,1) representing the statistical significance level for constructing the band}

\item{gridSize}{A numeric / vector to be used in constructing test set, should be provided when testSet is NuLL, else it is ignored. Default is \code{c(50,50)} for 2-dim input which is converted internally to a default of \code{c(1000)} for 1-dim input. Total number of test points (product of gridSize vector components) must be less than or equal to 2500.}

\item{powerbins}{A numeric stating the number of power bins for computing the scaled difference, default is 15.}

\item{baseline}{An integer between 0 to 2, where 1 indicates to use power curve of first dataset as the base for metric calculation, 2 indicates to use the power curve of second dataset as the base, and 0 indicates to use the average of both power curves as the base. Default is set to 1.}

\item{limitMemory}{A boolean (True/False) indicating whether to limit the memory use or not. Default is true. If set to true, 5000 datapoints are randomly sampled from each dataset under comparison for inference}

\item{opt_method}{A string specifying the optimization method to be used for hyperparameter estimation. Current options are: \code{'L-BFGS-B'}, \code{'BFGS'}, and \code{'nlminb'}. Default is set to \code{'nlminb'}.}

\item{sampleSize}{A named list of two integer items: \code{optimSize} and \code{bandSize}, denoting the sample size for each dataset for hyperparameter optimization and confidence band computation, respectively, when \code{limitMemory = TRUE}. Default value is \code{list(optimSize = 500, bandSize = 5000)}.}

\item{rngSeed}{Random seed for sampling data when \code{limitMemory = TRUE}. Default is 1.}
}
\value{
a list containing :
 \itemize{
  \item weightedDiff - a numeric,  \% difference between the functions weighted using the density of the covariates
  \item weightedStatDiff - a numeric, \% statistically significant difference between the functions weighted using the density of the covariates
  \item scaledDiff -  a numeric, \% difference between the functions scaled to the orginal data
  \item scaledStatDiff - a numeric, \% statistically significant difference between the functions scaled to the orginal data
  \item unweightedDiff - a numeric,  \% difference between the functions unweighted
  \item unweightedStatDiff - a numeric,  \% statistically significant difference between the functions unweighted
  \item reductionRatio -  a list consisting of shrinkage ratio of features used in testSet
  \item mu1 - a vector of prediction on testset using the first data set
  \item mu2 - a vector of prediction on testset using the second data set
   \item muDiff - a vector of the difference in prediction (mu2 - mu1) for each test point
  \item band - a vector for the confidence band at all the testpoints for the two functions to be the same at a given cofidence level.
  \item confLevel - a numeric representing the statistical significance level for constructing the band
  \item testSet - a vector/matrix of the test points either provided by user, or generated internally
  \item estimatedParams - a list of estimated hyperaparameters for the Gaussian process model
  \item matchedData - a list of two matched datasets as generated by covariate matching
}
}
\description{
Power curve comparison
}
\examples{

data1 = data1[1:100, ]
data2 = data2[1:100, ]
data = list(data1, data2)
xCol = 2
xCol.circ = NULL
yCol = 7
testCol = 2
testSet = NULL
thrs = 0.2
confLevel = 0.95
gridSize = 20
function_comparison = ComparePCurve(data, xCol, xCol.circ, yCol,
testCol, testSet, thrs, confLevel, gridSize)

}
\references{
For details, see Ding et al. (2021) available \doi{10.1016/j.renene.2021.02.136}.
}
