% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_eco.R
\name{read_eco}
\alias{read_eco}
\title{Reads parameters from a single DSSAT ecotype parameter file (*.ECO)}
\usage{
read_eco(file_name, col_types = NULL, col_names = NULL,
  left_justified = c("ECO   ", "ECO#", "ECONAME\\\\.*",
  "ECO-NAME\\\\.*"))
}
\arguments{
\item{file_name}{a character vector of length one that contains the name
of a single DSSAT output file}

\item{col_types}{One of NULL, a cols() specification, or a string.
See \code{\link[readr]{read_fwf}} or \code{vignette("readr")} for
more details.}

\item{col_names}{A character vector of column names; primarily
helpful for cases where there are no white spaces between column
names within the header line}

\item{left_justified}{A character vector of column names that
should be left justified}
}
\value{
a tibble containing the data from the raw DSSAT file
}
\description{
Reads parameters from a single DSSAT ecotype parameter file (*.ECO)
}
\examples{

# Extract file path for sample ecotype file path
sample_eco <- system.file('extdata','SAMPLE.ECO',package='DSSAT')

eco <- read_eco(sample_eco)

}
