% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.assign.r
\name{.datashield.assign}
\alias{.datashield.assign}
\title{Data assignment}
\usage{
.datashield.assign(
  opal,
  symbol,
  value,
  variables = NULL,
  missings = FALSE,
  identifiers = NULL,
  id.name = NULL,
  tibble = FALSE,
  async = TRUE
)
}
\arguments{
\item{opal}{Opal object.}

\item{symbol}{Name of the R symbol.}

\item{value}{Fully qualified name of a variable or a table in Opal or a R expression with allowed assign functions calls.}

\item{variables}{List of variable names or Javascript expression that selects the variables of a table (ignored if value does not refere to a table). See javascript documentation: http://wiki.obiba.org/display/OPALDOC/Variable+Methods}

\item{missings}{If TRUE, missing values will be pushed from Opal to R, default is FALSE. Ignored if value is an R expression.}

\item{identifiers}{Name of the identifiers mapping to use when assigning entities to R (from Opal 2.0).}

\item{id.name}{Name of the column that will contain the entity identifiers. If not specified, the identifiers
will be the data frame row names. When specified this column can be used to perform joins between data frames.}

\item{tibble}{Assign table to a tibble (from tidyverse) instead of a plain data.frame.}

\item{async}{Whether the call should be asynchronous.}
}
\value{
The R command ID if the async flag is TRUE and if the wait flag is FALSE and if Opal version is at least 2.1, NULL otherwise.
}
\description{
Assign a Opal value to a R symbol in the current Datashield session.
This operation is asynchronous and non blocking.
}
\keyword{internal}
