% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsRmSymbol}
\alias{dsRmSymbol}
\title{Remove a symbol}
\usage{
dsRmSymbol(conn, symbol)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{DSConnection-class}}.}

\item{symbol}{Name of the R symbol.}
}
\description{
After removal, the data identified by the symbol will not be accessible in the DataSHIELD R session on the server side.

\Sexpr[results=rd,stage=render]{DSI:::methods_as_rd("dsRmSymbol")}
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
dsAssignTable(con, "D", "test.CNSIM")
dsRmSymbol(con, "D")
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignResource}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasResource}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsKeepAlive}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListProfiles}()},
\code{\link{dsListResources}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}
}
\concept{DSConnection generics}
