% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_chronicvirusir_ode.R
\name{simulate_chronicvirusir_ode}
\alias{simulate_chronicvirusir_ode}
\title{Chronic Virus Infection and IR Model}
\usage{
simulate_chronicvirusir_ode(
  U = 1e+05,
  I = 0,
  V = 10,
  F = 1,
  T = 1,
  n = 10000,
  dU = 0.1,
  dI = 1,
  dV = 4,
  b = 1e-06,
  p = 100,
  g = 1,
  rF = 0.001,
  dF = 1,
  kF = 0.01,
  rT = 0.001,
  dT = 1,
  kT = 0.01,
  tstart = 0,
  tfinal = 200,
  dt = 0.1
)
}
\arguments{
\item{U}{: starting value for Uninfected cells : numeric}

\item{I}{: starting value for Infected cells : numeric}

\item{V}{: starting value for Virus : numeric}

\item{F}{: starting value for Innate Response : numeric}

\item{T}{: starting value for Adaptive Response : numeric}

\item{n}{: rate of new uninfected cell replenishment : numeric}

\item{dU}{: rate at which uninfected cells die : numeric}

\item{dI}{: rate at which infected cells die : numeric}

\item{dV}{: rate at which virus is cleared : numeric}

\item{b}{: rate at which virus infects cells : numeric}

\item{p}{: rate at which infected cells produce virus : numeric}

\item{g}{: possible conversion factor for virus units : numeric}

\item{rF}{: rate of innate response induction : numeric}

\item{dF}{: rate of innate response decay : numeric}

\item{kF}{: strength of innate response action : numeric}

\item{rT}{: rate of adaptive response induction : numeric}

\item{dT}{: rate of adaptive response decay : numeric}

\item{kT}{: strength of adaptive response action : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Time step : numeric}
}
\value{
The function returns the output as a list.
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}.
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
A model for a chronic virus infection with a simple immune response
}
\details{
The model includes uninfected and infected target cells, virus, and the innate and adaptive immune response. The processes that are modeled are cell birth and death, infection, virus production, infected cell and virus death. Immune response dynamics and action are also modeled. See the DSAIRM documentation for model details.

This code was generated by the modelbuilder R package.
The model is implemented as a set of ordinary differential equations using the deSolve package.
The following R packages need to be loaded for the function to work: deSolve.
}
\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\section{Model Author}{
 Andreas Handel
}

\section{Model creation date}{
 2022-05-09
}

\section{Code Author}{
 generated by the \code{modelbuilder} R package
}

\section{Code creation date}{
 2022-05-09
}

\examples{
# To run the simulation with default parameters:
result <- simulate_chronicvirusir_ode()
# To choose values other than the standard one, specify them like this:
result <- simulate_chronicvirusir_ode(U = 2e+05,I = 0,V = 2,F = 2,T = 2)
# You can display or further process the result, like this:
plot(result$ts[,'time'],result$ts[,'U'],xlab='Time',ylab='Numbers',type='l')
print(paste('Max number of U: ',max(result$ts[,'U'])))
}
