% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_basicbacteria_modelexploration.R
\name{simulate_basicbacteria_modelexploration}
\alias{simulate_basicbacteria_modelexploration}
\title{Simulation to illustrate parameter scan of the basic bacteria model
#'}
\usage{
simulate_basicbacteria_modelexploration(
  B = 100,
  I = 10,
  g = 2,
  Bmax = 1e+05,
  dB = 1,
  k = 1e-04,
  r = 1e-04,
  dI = 2,
  tstart = 0,
  tfinal = 300,
  dt = 0.1,
  samples = 10,
  parmin = 2,
  parmax = 10,
  samplepar = "g",
  pardist = "lin"
)
}
\arguments{
\item{B}{: Starting value for bacteria : numeric}

\item{I}{: Starting value for immune response : numeric}

\item{g}{: Maximum rate of bacteria growth : numeric}

\item{Bmax}{: Bacteria carrying capacity : numeric}

\item{dB}{: Bacteria death rate : numeric}

\item{k}{: Bacteria kill rate : numeric}

\item{r}{: Immune response growth rate : numeric}

\item{dI}{: Immune response decay rate : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Times for which result is returned : numeric}

\item{samples}{: Number of values to run between pmin and pmax : numeric}

\item{parmin}{: Lower value for varied parameter : numeric}

\item{parmax}{: Upper value for varied parameter : numeric}

\item{samplepar}{: Name of parameter to be varied : character}

\item{pardist}{: spacing of parameter values, can be either 'lin' or 'log' : character}
}
\value{
The function returns the output as a list,
list element 'dat' contains the data frame with results of interest.
The first column is called xvals and contains the values of the
parameter that has been varied as specified by 'samplepar'.
The remaining columns contain peak and steady state values of bacteria and immune response,
Bpeak, Ipeak, Bsteady and Isteady.
A final boolean variable 'steady' is returned for each simulation.
It is TRUE if the simulation reached steady state, otherwise FALSE.
}
\description{
This function simulates the simple bacteria model ODE for a range of parameters.
The function returns a data frame containing the parameter that has been varied and the outcomes (see details).
}
\details{
##this code illustrates how to do analyze a simple model.
A simple 2 compartment ODE model (the simple bacteria model introduced in the app of that name)
is simulated for different parameter values.
This function runs the simple bacterial infection model for a range of parameters.
The user can specify which parameter is sampled, and
the simulation returns for each parameter sample the peak and final value for B and I.
Also returned is the varied parameter and an indicator if steady state was reached.
}
\section{Notes}{
 The parameter dt only determines for which times the solution is returned,
it is not the internal time step. The latter is set automatically by the ODE solver.
}

\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter values
  or fractions > 1), the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
\dontrun{res <- simulate_basicbacteria_modelexploration()}
# To choose parameter values other than the standard one, specify them, like such:
res <- simulate_basicbacteria_modelexploration(samples=5, samplepar='dI', parmin=1, parmax=10)
# You should then use the simulation result returned from the function, like this:
plot(res$dat[,"xvals"],res$data[,"Bpeak"],xlab='Parameter values',ylab='Peak Bacteria',type='l')
}
\seealso{
See the shiny app documentation corresponding to this simulator
function for more details on this model.
}
\author{
Andreas Handel
}
