% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_fit_modelcomparison.R
\name{simulate_fit_modelcomparison}
\alias{simulate_fit_modelcomparison}
\title{Fitting 2 simple viral infection models to influenza data}
\usage{
simulate_fit_modelcomparison(U = 1e+05, I = 0, V = 1, X = 1,
  dI = 1, dV = 2, g = 0, p = 10, k = 1e-06, a = 1e-05,
  alow = 1e-06, ahigh = 1e-04, b = 1e-05, blow = 1e-06,
  bhigh = 0.001, r = 1, rlow = 0.1, rhigh = 2, dX = 1,
  dXlow = 0.1, dXhigh = 10, fitmodel = 1, iter = 100)
}
\arguments{
\item{U}{: initial number of uninfected target cells : numeric}

\item{I}{: initial number of infected target cells : numeric}

\item{V}{: initial number of infectious virions : numeric}

\item{X}{: initial level of immune response : numeric}

\item{dI}{: rate at which infected cells die : numeric}

\item{dV}{: rate at which infectious virus is cleared : numeric}

\item{g}{: unit conversion factor : numeric}

\item{p}{: rate at which infected cells produce virus : numeric}

\item{k}{: rate of killing of infected cells by T-cells (model 1) or virus by Ab (model 2) : numeric}

\item{a}{: activation of T-cells (model 1) or growth of antibodies (model 2) : numeric}

\item{alow}{: lower bound for activation rate : numeric}

\item{ahigh}{: upper bound for activation rate : numeric}

\item{b}{: rate at which virus infects cells : numeric}

\item{blow}{: lower bound for infection rate : numeric}

\item{bhigh}{: upper bound for infection rate : numeric}

\item{r}{: rate of T-cell expansion (model 1) : numeric}

\item{rlow}{: lower bound for expansion rate : numeric}

\item{rhigh}{: upper bound for expansion rate : numeric}

\item{dX}{: rate at which antibodies decay (model 2) : numeric}

\item{dXlow}{: lower bound for decay rate : numeric}

\item{dXhigh}{: upper bound for decay rate : numeric}

\item{fitmodel}{: fitting model 1 or 2 : numeric}

\item{iter}{: max number of steps to be taken by optimizer : numeric}
}
\value{
The function returns a list containing the best fit timeseries,
the best fit parameters, the data and the AICc for the model.
}
\description{
This function runs a simulation of a compartment model
using a set of ordinary differential equations.
The model describes a simple viral infection system in the presence of drug treatment.
The user provides initial conditions and parameter values for the system.
The function simulates the ODE using an ODE solver from the deSolve package.
The function returns a matrix containing time-series of each variable and time.
}
\details{
Two simple compartmental ODE models mimicking acute viral infection
with T-cells (model 1) or antibodies (model 2) are fitted to data.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values),
  the code will likely abort with an error message.
}

\examples{
# To run the code with default parameters just call the function:
\dontrun{result <- simulate_fit_modelcomparison()}
# To apply different settings, provide them to the simulator function, like such:
result <- simulate_fit_modelcomparison(iter = 5, fitmodel = 1)
}
\seealso{
See the Shiny app documentation corresponding to this
function for more details on this model.
}
\author{
Andreas Handel
}
