% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_maternalimmunity_ode.R
\name{simulate_maternalimmunity_ode}
\alias{simulate_maternalimmunity_ode}
\title{Simulation of a MSEIR model that represents a group of the population that is protected by disease through
maternal antibodies}
\usage{
simulate_maternalimmunity_ode(S = 1000, I = 1, tmax = 1000,
  m = 0.02, n = 0.02, p = 0.005, b = 0.3, gE = 0.1, gI = 0.02,
  w = 0)
}
\arguments{
\item{S}{: initial number of susceptible individuals : numeric}

\item{I}{: initial number of infected hosts : numeric}

\item{tmax}{: maximum simulation time : numeric}

\item{m}{: rate at which individuals are born : numeric}

\item{n}{: rate at which individuals die : numeric}

\item{p}{: rate at which individuals lose passive immunity : numeric}

\item{b}{: rate of new infections : numeric}

\item{gE}{: rate of leaving latent stage : numeric}

\item{gI}{: rate of recovery : numeric}

\item{w}{: rate of waning immunity : numeric}
}
\value{
The function returns the output from the odesolver as a matrix,
with one column per compartment/variable. The first column is time.
}
\description{
This function runs a simulation of a MSEIR model
using a set of 6 ordinary differential equations.
The user provides initial conditions and parameter values for the system.
The function simulates the ODE using an ODE solver from the deSolve package.
The function returns a matrix containing time-series of each variable and time.
}
\details{
A simple MSEIR model is simulated as a set of ordinary differential
equations, using an ode solver from the deSolve package.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter values
  or fractions > 1), the code will likely abort with an error message
}

\examples{
# To run the simulation with default parameters just call this function
result <- simulate_maternalimmunity_ode()
# To choose parameter values other than the standard one, specify them e.g. like such
result <- simulate_maternalimmunity_ode(S = 2000, I = 10, tmax = 100, b = 0.2)
# You should then use the simulation result returned from the function, e.g. like this:
plot(result$ts[ , "time"], result$ts[ , "S"],xlab='Time',ylab='Number Susceptible',type='l')
}
\seealso{
See the shiny app documentation corresponding to this simulator
function for more details on this model. See the manual for the deSolve
package for details on the underlying ODE simulator algorithm.
}
\author{
Chase Golden, Andreas Handel
}
