# Documentation for working on the DSAIDE package 

## Package structure 

### Main functions
* Folder /R contains the main R functions, i.e. the simulattors and various helper functions. 
* All simulators, which are meant to be called by advanced users start with simulate_. 
* The functions/files generate_text, generate_ggplot and generate_plotly can take results returned from the simulator functions and generate plots. 
* All other functions/files are only needed for the package/UI to work and are not meant to be directly accessed by users.
* While some of the functions are meant to be used as part of a shiny app, none deal with reactive content, all inputs and outputs are non-reactive objects.

### App materials
* The /inst folder contains several subfolders: 
  * The /appinformation subfolder contains files with documentation and settings for each simulator/app. Each App has an NNN_settings.R file and Rmd+HTML files containing the documentation. Those files contain the documentation displayed at the bottom of each app, and app-specific settings that are needed for proper display and running through the UI. Names of files and buttons in the main app.R need to agree.
 * /docsfordevelopers sub-folder contains this file
  * /DSAIDE subfolder contains the main app.R Shiny app. It also includes a css file for styling. A subfolder created by rsconnect during package upload to shinyapps.io might also be present. 
  * /media sub-folder contains figures and a bib file used as part of the documentation (i.e. the Rmd files). 
  * /simulatorfunctions subfolder contains the R code for all simulator functions. The functions in this folder are copies of the simulatorfunctions in the /R folder. They are used by the package to create the shiny UI (see the generate_shinyinput function). They are also contained in a zip folder which can be downloaded by users for easy access and editing.


### Other folders

* /auxiliary contains related resources that are not used/needed for package use or build
* /data contains data used as part of the R package.
* /doc contains the vignettes, this folder should not be edited, see below.
* /docs contains the package website created by the pkgdown package. Rebuild with pkgdown::build_site(). Don't edit manually.
* /man contains the documentation for all public functions, automatically generated by roxygen
* /Meta contains vignette information and is auto-created by devtools when package is built. Ignore.
* /pkgdown contains extra files for styling of pkgdown created website
* /tests contains unit tests, done with the testthat package
* /vignettes contains the vignette - this is copied to /inst/doc during package building. edits should be done to the file in the /vignettes folder, not the /inst/doc folder.

## Adding new apps/features

If you plan to build/contribute new apps or new features to the package, I would be delighted to include them! The best idea is to first contact me by email (ahandel@uga.edu) or through the Github site and tell me that you would like to contribute. We can then discuss a bit before you embark on the effort. 

To build a new app, you need to create at minimum the following:

* The main simulator_NNN function.
* The NNN_documentation.Rmd file.

Also needed (which could be done by you or me):

* The NNN_settings.R file. 
* A unit test for your new app in the testthat folder.
* Editing of app.R to include your new function.
* Adding any figures into the /media folder.
* Copying of your new simulator_NNN function into the simulatorfunctions folder and the zip file.
* Adding any cited references to the .bib file in the appinformation folder.
* Turning the documentation Rmd file into an HTML file.

## Information for package development

### To work on package through RStudio: 
* Fork and clone package from Rstudio.
* Load DSAIDE.Rproj in RStudio. Edit files as needed.
* Optionally, use RStudio tie-in with github to sync project to github (the 'git' tab). Alternativley, use your favorite git client.
* Rtools needs to be installed (on Windows)

### Dependency packages 
All libraries/packages needed to allow the package to run should be loaded via the DESCRIPTION file and not in separate R files. See that file for dependencies.

Additional packages are needed for development (but not use) of the package. Those are listed in the suggests section of the DESCRIPTION file. 


### To update R documentation and vignette
* Edit documentation inside R functions. 
* Build documentation with More/Document or devtools::document()
* Edit vignette inside the /vignettes folder.
* To build new vignette, run devtools::build_vignettes()
* To update the pkgdown website, run pkgdown::build_site()
* To spell-check all Rmd documentation files, use these commands (adjust paths as needed):
files = list.files(path = "C:/data/git/DSAIDE/inst/appinformation/", recursive=TRUE, pattern = "\\.Rmd$", full.names = TRUE)
spelling::spell_check_files(files)
* To re-build all html documentation files from the rmd files at once, use the above command to get all files, then:
for (n in 1: length(files)) {rmarkdown::render(files[n]); Sys.sleep(2)}
* To copy simulator functions into the /inst/simulator folder:
files = list.files(path = "C:/data/git/DSAIDE/R/", recursive=TRUE, pattern = "^simulate", full.names = TRUE)
file.copy(files, "C:/data/git/DSAIDE/inst/simulatorfunctions/", overwrite = TRUE)

### To build the package
* in RStudio, use the functions in the 'build' tab to test and build the package.
* Run clean and rebuild, then build and reload using menu, or devtools::load_all()
* Run the check, fix any errors 

### To deploy package to shinyappsio
* open app.R, set its folder as working directory
* make sure latest version is on Github and passes tests
* install the package through CRAN or github if we want to use the github version, e.g. devtools::install_github('ahgroup/DSAIDE')
* uncomment the library(DSAIDE) statement in app.R 
* to deploy, run the following rsconnect::deployApp()

### To-do at release time 
* "by hand" edit the DESCRIPTION file to make sure it's up to date
* Re-build documentation, re-build package
* Re-build vignettes with devtools::build_vignettes()
* Run check and make sure no problems occur
* Re-create package site with pkgdown::build_site()
* Sync everything to github
* Check vignette and function references on website, fix errors
* Run devtools::check_rhub() and devtools::check_win_devel()
* Do a test run of devtools::release()
