% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_sir_discrete.R
\name{simulate_sir_discrete}
\alias{simulate_sir_discrete}
\title{Basic discrete time SIR model}
\usage{
simulate_sir_discrete(S = 1000, I = 1, R = 0, b = 0.002, g = 1,
  tstart = 0, tfinal = 100, dt = 0.1)
}
\arguments{
\item{S}{: starting value for Susceptible : numeric}

\item{I}{: starting value for Infected : numeric}

\item{R}{: starting value for Recovered : numeric}

\item{b}{: infection rate : numeric}

\item{g}{: recovery rate : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Time step : numeric}
}
\value{
The function returns the output as a list. 
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
A basic SIR model with 3 compartments and infection and recovery processes
}
\details{
The model includes susceptible, infected, and recovered compartments. The two processes that are modeled are infection and recovery. The model is implemented as a discrete-time simulation.
}
\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\examples{
 
# To run the simulation with default parameters:  
result <- simulate_sir_discrete() 
}
