% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_multipathogen.R
\name{simulate_multipathogen}
\alias{simulate_multipathogen}
\title{Simulation of a compartmental infectious disease transmission model with 2 types of pathogens}
\usage{
simulate_multipathogen(S0 = 1000, I10 = 1, I20 = 0, I120 = 0,
  tmax = 120, b1 = 0.001, b2 = 0, b12 = 0, g1 = 1, g2 = 1,
  g12 = 1, a = 0)
}
\arguments{
\item{S0}{initial number of susceptible hosts}

\item{I10}{initial number of hosts infected with type 1}

\item{I20}{initial number of hosts infected with type 2}

\item{I120}{initial number of double infected hosts}

\item{tmax}{maximum simulation time, units of months}

\item{b1}{rate at which type 1 infected hosts transmit}

\item{b2}{rate at which type 2 infected hosts transmit}

\item{b12}{rate at which double infected hosts transmit}

\item{g1}{the rate at which infected type 1 hosts recover}

\item{g2}{the rate at which infected type 2 hosts recover}

\item{g12}{the rate at which double infected hosts recover}

\item{a}{fraction of type 1 infections produced by double infected hosts}
}
\value{
This function returns the simulation result as obtained from a call
  to the deSolve ode solver.
}
\description{
This model allows for the simulation of 2 IDs in a single host
}
\details{
A compartmental ID model with several states/compartments
  is simulated as a set of ordinary differential
  equations. The function returns the output from the odesolver as a matrix,
  with one column per compartment/variable. The first column is time.
}
\section{Warning}{

  This function does not perform any error checking. So if you try to do
  something nonsensical (e.g. any negative values or fractions > 1),
  the code will likely abort with an error message.
}

\examples{
  # To run the simulation with default parameters just call the function:
  result <- simulate_multipathogen()
  # To choose parameter values other than the standard one, specify them like such:
  result <- simulate_multipathogen(S0 = 100, I20 = 10,  tmax = 100, a = 0.5)
  # You should then use the simulation result returned from the function, like this:
  plot(result$ts[,"Time"], result$ts[ , "S"], xlab='Time', ylab='Number Susceptible', type='l')
  # We could set the infected type 1 host recovery rate at a high level, e.g., 1.2, and
  # examine the infected 1 curve.
  result <- simulate_multipathogen(S0 = 100, I20 = 10, tmax = 100, g1 = 1.2)
  plot(result$ts[,"Time"],result$ts[,"I1"], xlab="Time",ylab="Number Infected Type 1",type="l")
  # Additionally, consider making type 1 hosts transmit at a high rate.
  result <- simulate_multipathogen(S0 = 100, I20 = 10, tmax = 100, b1 = 2.5)
  plot(result$ts[,"Time"],result$ts[,"I1"], xlab="Time",ylab="Number Infected Type 1",type="l")
}
\references{
See e.g. Keeling and Rohani 2008 for SIR models and the
  documentation for the deSolve package for details on ODE solvers
}
\seealso{
The UI of the Shiny app 'Multi-Pathogen Dynamics', which is part of this package, contains more details on the model
}
\author{
Andreas Handel and Spencer Hall
}
