% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_did_rc.R
\name{reg_did_rc}
\alias{reg_did_rc}
\title{Outcome regression DiD estimator for the ATT, with repeated cross-section data}
\usage{
reg_did_rc(
  y,
  post,
  D,
  covariates,
  i.weights = NULL,
  boot = FALSE,
  boot.type = "weighted",
  nboot = NULL,
  inffunc = FALSE
)
}
\arguments{
\item{y}{An \eqn{n} x \eqn{1} vector of outcomes from the both pre and post-treatment periods.}

\item{post}{An \eqn{n} x \eqn{1} vector of Post-Treatment dummies (post = 1 if observation belongs to post-treatment period,
and post = 0 if observation belongs to pre-treatment period.)}

\item{D}{An \eqn{n} x \eqn{1} vector of Group indicators (=1 if observation is treated in the post-treatment, =0 otherwise).}

\item{covariates}{An \eqn{n} x \eqn{k} matrix of covariates to be used in the regression estimation.
If covariates = NULL, this leads to an unconditional DiD estimator.}

\item{i.weights}{An \eqn{n} x \eqn{1} vector of weights to be used. If NULL, then every observation has the same weights.}

\item{boot}{Logical argument to whether bootstrap should be used for inference. Default is FALSE.}

\item{boot.type}{Type of bootstrap to be performed (not relevant if \code{boot = FALSE}). Options are "weighted" and "multiplier".
If \code{boot = TRUE}, default is "weighted".}

\item{nboot}{Number of bootstrap repetitions (not relevant if \code{boot = FALSE}). Default is 999.}

\item{inffunc}{Logical argument to whether influence function should be returned. Default is FALSE.}
}
\value{
A list containing the following components:
 \item{ATT}{The OR DiD point estimate}
 \item{se}{The OR DiD standard error}
 \item{uci}{Estimate of the upper bound of a 95\% CI for the ATT}
 \item{lci}{Estimate of the lower bound of a 95\% CI for the ATT}
 \item{boots}{All Bootstrap draws of the ATT, in case bootstrap was used to conduct inference. Default is NULL}
 \item{att.inf.func}{Estimate of the influence function. Default is NULL}
 \item{call.param}{The matched call.}
 \item{argu}{Some arguments used (explicitly or not) in the call (panel = FALSE, boot, boot.type, nboot, type="or")}
}
\description{
\code{reg_did_rc} computes the outcome regressions estimators for the average treatment effect on the
treated in difference-in-differences (DiD) setups with stationary repeated cross-sectional data.
}
\details{
The \code{reg_did_rc} function implements
outcome regression difference-in-differences (DiD) estimator for the average treatment effect
on the treated (ATT) defined in equation (2.2) of Sant'Anna and Zhao (2020) when stationary repeated cross-sectional
data are available.  The estimator follows the same spirit of the nonparametric estimators proposed by Heckman, Ichimura and Todd (1997),
though here the the outcome regression models are assumed to be linear in covariates (parametric),

The nuisance parameters (outcome regression coefficients) are estimated via ordinary least squares.
}
\examples{
# use the simulated data provided in the package
covX = as.matrix(sim_rc[,5:8])
# Implement OR DiD estimator
reg_did_rc(y = sim_rc$y, post = sim_rc$post, D = sim_rc$d,
           covariates= covX)

}
\references{
\cite{Heckman, James J., Ichimura, Hidehiko, and Todd, Petra E. (1997),"Matching as an Econometric Evaluation Estimator: Evidence from Evaluating a Job Training Programme",
Review of Economic Studies, vol. 64(4), p. 605–654, \doi{10.2307/2971733}.
}


\cite{Sant'Anna, Pedro H. C. and Zhao, Jun. (2020),
"Doubly Robust Difference-in-Differences Estimators." Journal of Econometrics, Vol. 219 (1), pp. 101-122,
\doi{10.1016/j.jeconom.2020.06.003}}
}
