% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataAccess.R
\name{pooledCovDataAccess}
\alias{pooledCovDataAccess}
\title{Differentially Private Pooled Covariance Data Access Function}
\usage{
pooledCovDataAccess(
  samples,
  lower.bound1,
  upper.bound1,
  lower.bound2,
  upper.bound2,
  approx.n.max
)
}
\arguments{
\item{samples}{List of two-column matrices from which to compute the pooled
covariance.}

\item{lower.bound1, lower.bound2}{Real numbers giving the lower bounds of the
first and second columns of samples, respectively.}

\item{upper.bound1, upper.bound2}{Real numbers giving the upper bounds of the
first and second columns of samples, respectively.}

\item{approx.n.max}{Logical indicating whether to approximate n.max, which is
defined to be the length of the largest input vector. Approximation is best
if n.max is very large.}
}
\value{
List of the true pooled covariance and the sensitivities calculated
based on bounded and unbounded differential privacy.
}
\description{
This function performs the data access step in the computation of a
differentially private pooled covariance. The true values are computed using
the theoretical formula and \code{\link[stats]{cov}}, while the sensitivities
are calculated based on bounded and unbounded differential privacy
\insertCite{Kifer2011}{DPpack} according to the theoretical values
\insertCite{Liu2019b}{DPpack}.
}
\examples{
x1 <- matrix(c(1,4,-2,8,-6,-3),ncol=2)
x2 <- matrix(c(1,2,-5,7),ncol=2)
pooledCovDataAccess(list(x1,x2),-10,10,-10,10,FALSE)

}
\references{
\insertRef{Liu2019b}{DPpack}

\insertRef{Kifer2011}{DPpack}
}
\keyword{internal}
