% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.DOVE.R
\name{plot}
\alias{plot}
\alias{plot.DOVE}
\title{Plot Estimated Vaccine Efficacy}
\usage{
\method{plot}{DOVE}(x, y, ..., bandwidth = NULL)
}
\arguments{
\item{x}{An DOVE object. The value object returned by dove() and dove2().}

\item{y}{ignored.}

\item{...}{ignored}

\item{bandwidth}{A numeric vector object. A tuning parameter for the 
bandwidth used for kernel estimation of the vaccine efficacy in 
reducing the hazard rate for objects returned by dove(). This
input is ignored for objects returned by dove2().}
}
\value{
No return value, called to produce graphical elements.
}
\description{
Generates plots of the estimated vaccine efficacy in reducing attack rate, 
  the estimated vaccine efficacy in reducing the hazard rate, 
  and their 95\% confidence intervals.
}
\examples{
data(doveData)

set.seed(1234)

smp <- sample(1:nrow(x = doveData), 500, FALSE)

# NOTE: This sample size is chosen for example only -- larger data sets
# should be used.
# See the vignette for a full dove() analysis of the doveData dataset

result <- dove(formula = Surv(event.time, event.status) ~ priority + sex + 
                         vaccine(entry.time, vaccine.status, vaccine.time),
               data = doveData[smp,])

plot(x = result, bandwidth = c(0.5,1.0))

set.seed(1234)
smp <- sample(1L:nrow(x = doveData), size = 2500L)

# NOTE: This sample size is chosen for example only -- larger data sets
# should be used.
# See the vignette for a full dove2() analysis of the doveData dataset

# Fit the model with default settings
result <- dove2(formula = Surv(event.time, event.status) ~ priority + sex + 
                          vaccine(entry.time, vaccine.status, vaccine.time), 
                data = doveData[smp,])

plot(x = result)

}
