% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSE_Plotting.R
\name{barplot.MSE}
\alias{barplot.MSE}
\title{Plot a barplot of MSE results}
\usage{
\method{barplot}{MSE}(height, MSEobj = NULL, PMs = list(B_BMSY = 0.5,
  SSB_SSB0 = 0.2), PLim = 0.8, lastYrs = 10, maxMP = 14, MPs = NA,
  Title = NULL, sims = NULL, msg = TRUE, cex.names = 1.3,
  incRef = FALSE, ...)
}
\arguments{
\item{height}{An object of class MSE. Generic function must have argument
height. But note that this must be an MSE object.}

\item{MSEobj}{Optional. An object of class MSE. Overides \code{height}}

\item{PMs}{List of performance metrics. Options are \code{c('SSB_SSB0',
'B_BMSY', 'F_FMSY', 'AAVE', 'AAVY')}}

\item{PLim}{Probability threshold}

\item{lastYrs}{Last number of years in projection to calculate statistics}

\item{maxMP}{Maximum number of MPs to include in each plot}

\item{MPs}{Optional subset MSE object by MP}

\item{Title}{Optional title for plot}

\item{sims}{Optional subset MSE object by simulation}

\item{msg}{Logical. Print out messages?}

\item{cex.names}{Size of names}

\item{incRef}{Logical. Include the reference methods?}

\item{...}{Optional additional arguments passed to \code{barplot}}
}
\description{
Plot a barplot of MSE results
}
\author{
A. Hordyk
}
