% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineClasses.r
\docType{class}
\name{Stock-class}
\alias{Stock-class}
\title{Class \code{'Stock'}}
\description{
An operating model component that specifies the parameters of the population
dynamics model
}
\section{Slots}{

\describe{
\item{\code{Name}}{The name of the Stock object. Single value. Character string}

\item{\code{Species}}{Scientific name of the species. Genus and species name. Character string}

\item{\code{maxage}}{The maximum age of individuals that is simulated (there is no 'plus group'). Single value. Positive integer}

\item{\code{R0}}{The magnitude of unfished recruitment. Single value. Positive real number}

\item{\code{M}}{Natural mortality rate. Uniform distribution lower and upper bounds. Positive real number}

\item{\code{M2}}{(Optional) Natural mortality rate at age. Vector of length 'maxage'. Positive real number}

\item{\code{Mexp}}{Exponent of the Lorenzen function assuming an inverse relationship between M and weight. Uniform distribution lower and upper bounds. Real numbers <= 0.}

\item{\code{Msd}}{Inter-annual variability in natural mortality rate expressed as a coefficient of variation. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Mgrad}}{Mean temporal trend in natural mortality rate, expressed as a percentage change in M per year. Uniform distribution lower and upper bounds. Real numbers}

\item{\code{h}}{Steepness of the stock recruit relationship. Uniform distribution lower and upper bounds. Values from 1/5 to 1}

\item{\code{SRrel}}{Type of stock-recruit relationship. Single value, switch (1) Beverton-Holt (2) Ricker. Integer}

\item{\code{Perr}}{Process error, the CV of lognormal recruitment deviations. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{AC}}{Autocorrelation in recruitment deviations rec(t)=AC*rec(t-1)+(1-AC)*sigma(t). Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Period}}{(Optional) Period for cyclical recruitment pattern in years. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Amplitude}}{(Optional) Amplitude in deviation from long-term average recruitment during recruitment cycle (eg a range from 0 to 1 means recruitment decreases or increases by up to 100\% each cycle). Uniform distribution lower and upper bounds. 0 < Amplitude < 1}

\item{\code{Linf}}{Maximum length. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{K}}{von Bertalanffy growth parameter k. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{t0}}{von Bertalanffy theoretical age at length zero. Uniform distribution lower and upper bounds. Non-positive real numbers}

\item{\code{LenCV}}{Coefficient of variation of length-at-age (assumed constant for all age classes). Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Ksd}}{Inter-annual variability in growth parameter k. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Kgrad}}{Mean temporal trend in growth parameter k, expressed as a percentage change in k per year. Uniform distribution lower and upper bounds. Real numbers}

\item{\code{Linfsd}}{Inter-annual variability in maximum length. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Linfgrad}}{Mean temporal trend in maximum length, expressed as a percentage change in Linf per year. Uniform distribution lower and upper bounds. Real numbers}

\item{\code{L50}}{Length at 50 percent maturity. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{L50_95}}{Length increment from 50 percent to 95 percent maturity. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{D}}{Current level of stock depletion SSB(current)/SSB(unfished). Uniform distribution lower and upper bounds. Fraction}

\item{\code{a}}{Length-weight parameter alpha. Single value. Positive real number}

\item{\code{b}}{Length-weight parameter beta. Single value. Positive real number}

\item{\code{Size_area_1}}{The size of area 1 relative to area 2. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Frac_area_1}}{The fraction of the unfished biomass in stock 1. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Prob_staying}}{The probability of inviduals in area 1 remaining in area 1 over the course of one year. Uniform distribution lower and upper bounds. Positive fraction.}

\item{\code{Fdisc}}{Fraction of discarded fish that die. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Source}}{A reference to a website or article from which parameters were taken to define the stock object. Single value. Character string.}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('Stock')}
}

\examples{

showClass('Stock')

}
\author{
T. Carruthers and A. Hordyk
}
\keyword{classes}
