% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{CalcInput}
\alias{CalcInput}
\title{Apply input control recommendations and calculate population dynamics}
\usage{
CalcInput(y, nyears, proyears, InputRecs, nsim, nareas, LR5_P, LFR_P, Rmaxlen_P,
  maxage, retA_P, retL_P, V_P, V2, pSLarray, SLarray2, DR, maxlen, Len_age,
  CAL_binsmid, Fdisc, nCALbins, E_f, SizeLim_f, VBiomass_P, Biomass_P,
  Spat_targ, FinF, qvar, qs, qinc, CB_P, CB_Pret, FM_P, FM_retain, Z_P,
  M_ageArray, LastEffort, LastSpatial, LastAllocat)
}
\arguments{
\item{y}{Simulation year}

\item{nyears}{Number of historical}

\item{proyears}{Number of projection years}

\item{InputRecs}{Input control recommendations}

\item{nsim}{Number of simulations}

\item{nareas}{Number of areas}

\item{LR5_P}{Length at 5 percent retention}

\item{LFR_P}{Length at full retention}

\item{Rmaxlen_P}{Retention of maximum length}

\item{maxage}{Maximum age}

\item{retA_P}{Retention at age}

\item{retL_P}{Retention at length}

\item{V_P}{Realized vulnerability at age}

\item{V2}{Gear vulnerability at age}

\item{pSLarray}{Realized vulnerability at length}

\item{SLarray2}{Gear vulnerability at length}

\item{DR}{Discard ratio}

\item{maxlen}{maximum length}

\item{Len_age}{Length-at-age}

\item{CAL_binsmid}{Length-bin mid-points}

\item{Fdisc}{Fraction of discarded fish that die}

\item{nCALbins}{Number of length bins}

\item{E_f}{Implementation error on effort recommendation}

\item{SizeLim_f}{Implementation error on size limit}

\item{VBiomass_P}{Vulnerable biomass-at-age}

\item{Biomass_P}{Biomass-at-age}

\item{Spat_targ}{Spatial targetting}

\item{FinF}{Final fishing effort}

\item{qvar}{Annual ariability in catchability}

\item{qs}{Catchability}

\item{qinc}{Numeric vector (nsim) increased}

\item{CB_P}{Numeric array (nsim, maxage, proyears, nareas) Catch biomass at age}

\item{CB_Pret}{Numeric array (nsim, maxage, proyears, nareas) Retained catch biomass at age}

\item{FM_P}{Numeric array (nsim, maxage, proyears, nareas) Fishing mortality at age}

\item{FM_retain}{Numeric array (nsim, maxage, proyears, nareas) Retained fishing mortality at age}

\item{Z_P}{Numeric array (nsim, maxage, proyears, nareas) Total mortality at age}

\item{M_ageArray}{Numeric array (nsim, maxage, nyears+proyears) Natural mortality at age}

\item{LastEffort}{Numeric vector (nsim) with fishing effort from last year}

\item{LastSpatial}{Numeric matrix (nsim, nareas) with spatial closures from last year}

\item{LastAllocat}{Numeric vector (nsim) with allocation from last year}
}
\description{
Internal function
}
\author{
A. Hordyk
}
\keyword{internal}
