% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSEObj.r
\name{boxplot.MSE}
\alias{boxplot.MSE}
\title{Boxplot of MP performance from MSE object}
\usage{
\method{boxplot}{MSE}(x, MPs = NA, maxMP = 8, PMRefs = list(B_BMSY = 1,
  SSB_SSB0 = 0.2, F_FMSY = 1, AAVY = 30, AAVE = 30), lastYrs = 10,
  cex.lab = 1.2, cex.PM = 0.75, canMPs = NULL, cols = TRUE,
  outline = FALSE, CexName = 1.25, incLine = TRUE, incref = FALSE,
  Names = TRUE, ...)
}
\arguments{
\item{x}{An object of class MSE}

\item{MPs}{Optional subset MSE object by MP}

\item{maxMP}{Maximum number of MPs to plot}

\item{PMRefs}{List containing the Performance Metrics reference points.
Options are \code{'SSB_SSB0', 'B_BMSY', 'F_FMSY', 'AAVE', 'AAVY'}}

\item{lastYrs}{Last number of years in projection to calculate statistics}

\item{cex.lab}{Size of axis label text}

\item{cex.PM}{Size of performacne metric text}

\item{canMPs}{Optional character vector of MPs that can be applied (plotted
in different colour)}

\item{cols}{Optional vector of colours}

\item{outline}{Logical. Include outliers in boxplot?}

\item{CexName}{Size of the names}

\item{incLine}{Logical. Include vertical line?}

\item{incref}{Logical. Include reference methods?}

\item{Names}{Logical. Include MP names in plot?}

\item{...}{Additional arguments to be passed to plotting functions}
}
\description{
Boxplot of MP performance from MSE object
}
\author{
A. Hordyk
}
