% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIscBIO-generic-FinalPreprocessing.R
\name{FinalPreprocessing}
\alias{FinalPreprocessing}
\alias{FinalPreprocessing,DISCBIO-method}
\title{Final Preprocessing}
\usage{
FinalPreprocessing(
  object,
  GeneFlitering = "NoiseF",
  export = FALSE,
  quiet = FALSE,
  fileName = "filteredDataset"
)

\S4method{FinalPreprocessing}{DISCBIO}(
  object,
  GeneFlitering = "NoiseF",
  export = FALSE,
  quiet = FALSE,
  fileName = "filteredDataset"
)
}
\arguments{
\item{object}{\code{DISCBIO} class object.}

\item{GeneFlitering}{GeneFlitering has to be one of the followings:
["NoiseF","ExpF"]. Default is "NoiseF"}

\item{export}{A logical vector that allows writing the final gene list in
excel file. Default is TRUE.}

\item{quiet}{if `TRUE`, intermediary output is suppressed}

\item{fileName}{File name for exporting (if `export = TRUE`)}
}
\value{
The DISCBIO-class object input with the FinalGeneList slot filled.
}
\description{
This function generates the final filtered normalized dataset.
}
\examples{
#sc <- DISCBIO(valuesG1msTest)
#sc <- NoiseFiltering(sc, percentile = 0.9, CV = 0.2, export = FALSE)
#sc <- FinalPreprocessing(sc, GeneFlitering = "NoiseF", export = FALSE)

}
