% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.DIFtree.R
\name{predict.DIFtree}
\alias{predict.DIFtree}
\title{Prediction from fitted Item focussed Trees}
\usage{
\method{predict}{DIFtree}(object, item, newdata, ...)
}
\arguments{
\item{object}{Object of class \code{\link[DIFtree]{DIFtree}}}

\item{item}{Number of the item, for which the prediction shall be returned}

\item{newdata}{New data.frame, for which the prediction shall be returned}

\item{...}{Further arguments passed to or from other methods}
}
\description{
The function returns predictions of item parameters 
obtained by item focussed recursive partitioning based on the Rasch Model or the 
Logistic Regression Approach for DIF detection.
}
\details{
For \code{"Rasch"} model the function returns the predicted item difficulty. 
For \code{"Logistic"} models the function returns the predicted intercept and/or slope.
}
\examples{
data(data_sim)
 
Y <- data_sim[,1]
X <- data_sim[,-1]

Xnew <- data.frame("x1"=c(0,1),"x2"=c(-1.1,2.5),"x3"=c(1,0),"x4"=c(-0.2,0.7))
 
\dontrun{
 
mod <- DIFtree(Y=Y,X=X,model="Logistic",type="udif",alpha=0.05,nperm=1000,trace=TRUE)
 
predict(mod,item=1,Xnew)
}

}
\author{
Moritz Berger <moritz.berger@stat.uni-muenchen.de> \cr \url{http://www.statistik.lmu.de/~mberger/}
}
\references{
Berger, Moritz and Tutz, Gerhard (2015): Detection of Uniform and Non-Uniform Differential Item Functioning 
by Item Focussed Trees, Cornell University Library, arXiv:1511.07178

Tutz, Gerhard and Berger, Moritz (2015): Item Focused Trees for the Identification of Items
in Differential Item Functioning, Psychometrika, published online, DOI: 10.1007/s11336-015-9488-3
}
\seealso{
\code{\link[DIFtree]{DIFtree}}, \code{\link[DIFtree]{plot.DIFtree}}, \code{\link[DIFtree]{summary.DIFtree}}
}

