% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fert.R
\name{fert}
\alias{fert}
\title{Calculates fertility indicators based on the Demographic and Health Surveys (DHS).}
\usage{
fert(Data.Name, Indicator, JK = NULL, Strata = NULL, Cluster = NULL,
  Weight = NULL, Year_of_survey = NULL, Date_of_interview = NULL,
  Woman_DOB = NULL, EverMW = NULL, AWFact = NULL, PeriodEnd = NULL,
  Period = NULL, Class = NULL)
}
\arguments{
\item{Data.Name}{DHS data women files (IR).}

\item{Indicator}{Type of indicator to be calculated ("tfr", "gfr", "asfr").}

\item{JK}{"Yes" to estimate Jackknife SE for TFR.}

\item{Strata}{The stratification variable name if other than "v022".}

\item{Cluster}{The sampling clusters variable name if other than "v021".}

\item{Weight}{The sampling weight variable name if other than "v005".}

\item{Year_of_survey}{Year of survey variable if other than "v007".}

\item{Date_of_interview}{Date of Interview variable if other than "v008".}

\item{Woman_DOB}{Woman date of birth variable if other than "v011".}

\item{EverMW}{"Yes" for ever-married women data.}

\item{AWFact}{The all-women-factor variable name; only for ever-married women data.}

\item{PeriodEnd}{The end year of the exposure period; default is the year of the survey.}

\item{Period}{The study period for fertility; default is 3 years.}

\item{Class}{Allow for domain level indicators.}
}
\value{
Fertility indicators (TFR, GFR or ASFR), and precision indicators (SE, DEFT, RSE and CI).
}
\description{
\code{fert} returns fertility indicators such as Total Fertility Rate (TFR),
General Fertility Rate (GFR) and Age Specific Fertility Rate (ASFR)
\code{fert} returns the Standrad Error (SE), the fertility exposure (N), the weighted exposure (WN),
the Design Effect (DEFT), the Relative Standard Error (RSE) and the Confidence Interval (CI).
}
\examples{
# Calculate TFR and estimate Jackknife SE based on all women AWIR70 data

data("AWIR70")
Total_Fertility_Rate <- fert(
 AWIR70,
 Indicator = "tfr",
 JK = "Yes"
)

# Calculate GFR and estimate SE based on ever-married women EMIR70 data

data("EMIR70")
General_Fertility_Rate <- fert(
 EMIR70,
 Indicator = "gfr",
 EverMW = "YES",
 AWFact = "awfactt"
)

# Calculate Urban/Rural level ASFR and estimate SE based on all women AWIR70 data

data("AWIR70")
Age_Specific_Fertility_Rate <- fert(
 AWIR70,
 Indicator = "asfr",
 Class = "v025"
)

}
\author{
Mahmoud Elkasabi.
}
