% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DHARMa.R
\name{createDHARMa}
\alias{createDHARMa}
\title{Create a DHARMa object from hand-coded simulations or Bayesian posterior predictive simulations}
\usage{
createDHARMa(simulatedResponse, observedResponse,
  fittedPredictedResponse = NULL, integerResponse = F, seed = 123,
  method = c("PIT", "traditional"), rotation = NULL)
}
\arguments{
\item{simulatedResponse}{matrix of observations simulated from the fitted model - row index for observations and colum index for simulations}

\item{observedResponse}{true observations}

\item{fittedPredictedResponse}{optional fitted predicted response. For Bayesian posterior predictive simulations, using the median posterior prediction as fittedPredictedResponse is recommended. If not provided, the mean simulatedResponse will be used.}

\item{integerResponse}{if T, noise will be added at to the residuals to maintain a uniform expectations for integer responses (such as Poisson or Binomial). Unlike in \code{\link{simulateResiduals}}, the nature of the data is not automatically detected, so this MUST be set by the user appropriately}

\item{seed}{the random seed to be used within DHARMa. The default setting, recommended for most users, is keep the random seed on a fixed value 123. This means that you will always get the same randomization and thus teh same result when running the same code. NULL = no new seed is set, but previous random state will be restored after simulation. FALSE = no seed is set, and random state will not be restored. The latter two options are only recommended for simulation experiments. See vignette for details.}

\item{method}{the quantile randomization method used. The two options implemented at the moment are probability integral transform (PIT-) residuals (current default), and the "traditional" randomization procedure, that was used in DHARMa until version 0.3.0. For details, see \code{\link{getQuantile}}}

\item{rotation}{optional rotation of the residual space to remove residual autocorrelation. See details in \link{simulateResiduals}, section \emph{residual auto-correlation} for an extended explanation, and \link{getQuantile} for syntax.}
}
\description{
Create a DHARMa object from hand-coded simulations or Bayesian posterior predictive simulations
}
\details{
The use of this function is to convert simulated residuals (e.g. from a point estimate, or Bayesian p-values) to a DHARMa object, to make use of the plotting / test functions in DHARMa
}
\note{
Either scaled residuals or (simulatedResponse AND observed response) have to be provided
}
\examples{
## READING IN HAND-CODED SIMULATIONS

testData = createData(sampleSize = 50, randomEffectVariance = 0)
fittedModel <- glm(observedResponse ~ Environment1, data = testData, family = "poisson")

# in DHARMA, using the simulate.glm function of glm 
sims = simulateResiduals(fittedModel)
plot(sims, quantreg = FALSE)

# Doing the same with a handcoded simulate function. 
# of course this code will only work with a 1-par glm model
simulateMyfit <- function(n=10, fittedModel){
  int = coef(fittedModel)[1]
  slo = coef(fittedModel)[2]
  pred = exp(int + slo * testData$Environment1)
  predSim = replicate(n, rpois(length(pred), pred))
  return(predSim)
}

sims = simulateMyfit(250, fittedModel)

dharmaRes <- createDHARMa(simulatedResponse = sims, 
                          observedResponse = testData$observedResponse, 
                          fittedPredictedResponse = predict(fittedModel, type = "response"), 
                          integer = TRUE)
plot(dharmaRes, quantreg = FALSE)
}
