% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBenchmarks.R
\name{runBenchmarks}
\alias{runBenchmarks}
\title{Benchmark calculations}
\usage{
runBenchmarks(calculateStatistics, controlValues = NULL, nRep = 10,
  alpha = 0.05, parallel = F, ...)
}
\arguments{
\item{calculateStatistics}{the statistics to be benchmarked. Should return one value, or a vector of values. If controlValues are given, must accept a paramteter control}

\item{controlValues}{a vector with a control parameter (e.g. to vary the strength of a problem the test should be specific to)}

\item{nRep}{number of replicates per level of the controlValues}

\item{alpha}{significance level}

\item{parallel}{whether to use parallel computations. Possible values are F, T (sets the cores automatically to number of available cores -1), or an integer number for the number of cores that should be used for the cluster}

\item{...}{additional parameters to calculateStatistics}
}
\description{
This function runs statistical benchmarks, including Power / Type I error simulations for an arbitrary test with a control parameter
}
\note{
The benchmark function in DHARMa are intended for development purposes, and for users that want to test / confirm the properties of functions in DHARMa. If you are running an applied data analysis, they are probably of little use.
}
