% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmItem.R
\name{rmItems}
\alias{rmItems}
\title{Removes list of named data items}
\usage{
rmItems(dgeObj, items)
}
\arguments{
\item{dgeObj}{A DGEobj}

\item{items}{Either a character vector of names or numeric indexes of items to remove.  Use inventory(DGEobj) to view the indexes of items.}
}
\value{
A DGEobj
}
\description{
Removes list of named data items
}
\examples{
    # example DGEobj
    exObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

    exObj <- rmItems(exObj, c("design", "design_orig"))
    exObj <- rmItems(exObj, c(1:2))

}
