% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeSigCounts.R
\name{summarizeSigCounts}
\alias{summarizeSigCounts}
\title{Summarize a contrast list}
\usage{
summarizeSigCounts(
  contrastList,
  columns = c("P.Value", "adj.P.Val", "Qvalue", "qvalue.lfdr", "ihw.adj_pvalue"),
  sigThresholds = c(0.01, 0.05, 0.05, 0.05, 0.05),
  fcThreshold = 0
)
}
\arguments{
\item{contrastList}{A list of topTable dataframes.}

\item{columns}{Vector of column names to summarize from topTable dataframes.
Default = c("P.Value", "adj.P.Val", "Qvalue", "qvalue.lfdr", "ihw.adj_pvalue")}

\item{sigThresholds}{Thresholds to use for each column specified in columns
Must be same length at columns argument.
Default = c(0.01, 0.05, 0.05, 0.05, 0.05)}

\item{fcThreshold}{Fold-change threshold (absolute value, not logged.)}
}
\value{
data.frame with one summary row per contrast.
}
\description{
Takes a contrast list produced by runContrasts. Defaults are provided to specify columns to
summarize and thresholds for each column, though they can be adjusted. A fold change
threshold can optionally be specified. The function queries the topTable results and
returns a dataframe with the summary results, but only includes gene counts that meet
the specified conditions.
}
\details{
Any specified column names that don't exist will be ignored. Normally the
defaults cover all the p-value and FDR related columns. However, a fcThreshold
can be added and the p-value/FDR thresholds can be modified using the fcThreshold
and sigThresholds arguments, respectively.
}
\examples{
   dgeObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))
   contrastList <- DGEobj::getType(dgeObj, type = "topTable")

   #all defaults
   sigSummary <- summarizeSigCounts(contrastList)

   #add the fold-chage threshold
   sigSummary <- summarizeSigCounts(contrastList, fcThreshold = 2)

   #change the significance thresholds
   sigSummary <- summarizeSigCounts(contrastList,
                                    sigThresholds = c(0.01, 0.1, 0.1, 0.1, 0.1))

}
