% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{plot_mds_hulls}
\alias{plot_mds_hulls}
\title{Visualize multi-dimensional scaled data for all samples, with group-wise metadata incorporated as colors, shapes, and convex hulls.}
\usage{
plot_mds_hulls(filename = "mds_hulls_plot.pdf", color_var,
  shape_var = "none", deOnly = FALSE, showLabel = FALSE,
  hullType = "solid", exclude_data = FALSE, idCol = "",
  excludeCol = "", excludeName = "", theme = 1,
  customLabels = FALSE, returnData = FALSE)
}
\arguments{
\item{filename}{Filename for output plot.  Valid extensions are ".pdf" and ".png".
File generation for plot file can be turned off using set_output_mode("screen").
Output will be written to the /MDS/hulls/ directory.}

\item{color_var}{The group from target data that should be indicated by color.
Any column of metadata can be used, regardless of experimental design. String.}

\item{shape_var}{The group from target data that should be indicated by shape.
Any column of metadata can be used, regardless of experimental design. String. Optional. Default="none".}

\item{deOnly}{Use only DE genes when computing the plot.  Requires that create_master_res() be run first. Boolean.}

\item{showLabel}{Show labels indicating sample identifiers on the plot. Boolean.  Default=FALSE.}

\item{hullType}{Determines hull type, either "solid" or "outline". Solid hulls are partially transparent overlaying polygons.
Outline hulls trace an outline along the outermost distant samples of each group.  Default="solid".}

\item{exclude_data}{Exclude some subset of data from this plot. If this is TRUE, three additional parameters must be provided:
idCol, excludeCol, and excludeName.  These will then be used to subset the data for the MDS as desired.  For example,
it is possible to remove "Day1" data from your "Timepoint" field, or "Control_Sample" from your condition field.
I.E. Remove control samples from the visualization. Logical. Default=FALSE.}

\item{idCol}{Required only if exclude_data is TRUE.  The ID column in target data that corresponds to column names in count data.}

\item{excludeCol}{Required only if exclude_data is TRUE. The field from which exclusion criteria will be determined.
Must match a column name from target data.}

\item{excludeName}{Required only if exclude_data is TRUE. Value to exclude from the data based on the excludeCol.
Must match a level in the excludeCol.}

\item{theme}{Theme for the layout and color scheme for the MDS plot.  Valid selections are integers between 1-6.}

\item{customLabels}{If customLabels is set to TRUE, the user will be prompted to provide a custom label for each label.}

\item{returnData}{If this value is true, this function will return a sample distance matrix. Default: FALSE}
}
\value{
If returnData is true, this function will return a matrix containing sample distances computed to create the MDS plot.
}
\description{
This function performs multi-dimensional scaling (MDS) on data to visualize levels of similarity between individual samples.
Distance measurements can be calculated based only on the differentially expressed genes for each sample.
Colors and shape variables can be specified according to available metadata, making it possible to identify patterns in the data
based on groups.  Additionally, convex hulls are computed and drawn indicating the overall clustering range of samples in a group-wise manner.
}
\examples{
\dontrun{

#These examples assume "Time", "Infection", and sampleType columns exist in target metadata.

 /*
  * Create a MDS plot with convex hulls drawn based on "Time" metadata.
  * Shapes are based on "Infection".  Compute based on data from all genes.
  */
plot_mds_hulls("mds_hull_plot.pdf", "Time", "Infection",
                deOnly=FALSE, showLabel=FALSE, hullType="solid",
                theme=1)

 /*
  * Create a MDS plot with convex hulls drawn based on "Time" metadata.
  * Shapes are based on "Infection".  Compute based on data from only
  * differentailly expressed genes.  Hulls drawn only as outlines.
  */
plot_mds_hulls("mds_hull_deOnly_plot.pdf", "Time", "Infection",
                deOnly=TRUE, showLabel=FALSE, hullType="outline",
                theme=2)

 /*
  * Create a MDS plot with convex hulls drawn based on "Time" metadata.
  * Shapes are based on "Infection".  Compute based on data from only
  * differentailly expressed genes.  Do not show samples labeled
  * as "mock" from "sampleType" column of target metadata.
  */
plot_mds_hulls("mds_hull_deOnly_plot.pdf", "Time", "Infection",
                deOnly=TRUE, showLabel=FALSE, hullType="outline",
                exclude_data=TRUE, idCol="sampleID",
                excludeCol="sampleType", excludeName="mock"
                theme=4)

}
}
\seealso{
\code{\link{plot_mds}}
}
\keyword{DE}
\keyword{distance}
\keyword{hull}
\keyword{mds}
\keyword{visualization}
