% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-methods.R
\name{plot,DeponsTrack,missing-method}
\alias{plot,DeponsTrack,missing-method}
\alias{plot.DeponsTrack}
\title{Plot a DeponsTrack object}
\usage{
\S4method{plot}{DeponsTrack,missing}(x, y, trackToPlot = 1, add = FALSE, ...)
}
\arguments{
\item{x}{DeponsTrack object}

\item{y}{Not used}

\item{trackToPlot}{Integer; indicates which track to plot if there is more
than one track in the object. Defaults to 1}

\item{add}{Logical, whether to add the track to an existing plot
one animal was tracked during the simulation.}

\item{...}{Optional plotting parameters}
}
\description{
Plot the coordinates in a movement track simulated with DEPONS.
}
\examples{
data(porpoisetrack)
data("porpoisetrack")
plot(porpoisetrack)

\donttest{
# Optional: Transform and plot coastline if rgdal is installed
data("coastline")
library(rgdal)
coast2 <- sp::spTransform(coastline, CRS("+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs"))
# Check that the coastline-map is projected the same way as the track before
# plotting:
as.character(crs(porpoisetrack)) == as.character(crs(coast2))
plot(coast2, col="lightyellow2", add=TRUE)
}
}
