\name{moranI.boot}

\alias{moranI.boot}
\alias{moranI.pboot}

\title{Generate Bootstrap Replicates of Moran's I Autocorrelation Statistic}


\description{

Generate bootstrap replicates of Moran's I autocorrelation statistic, by means
of function \emph{boot} form \emph{boot} library. Notice that these functions
should not  be used separately but as argument \emph{statistic} when calling
function \emph{boot}.

\emph{moranI.boot} is used when performing a non-parametric bootstrap.

\emph{moranI.pboot} is used when performing a parametric bootstrap.
}


\usage{
moranI.boot(data, i, ...)
moranI.pboot(...)
}

\arguments{
\item{data}{A dataframe containing the data, as specified in the 
\bold{DCluster}manpage.}
\item{i}{Permutation generated by the bootstrap procedure}
\item{...}{Aditional arguments passed when performing a bootstrap.}
}

\value{
Both functions return the value of the statistic.
}

\seealso{
DCluster, boot, moranI, moranI.stat
}


\examples{
library(spdep)
data(nc.sids)
col.W <- nb2listw(ncCR85.nb, zero.policy=TRUE)

sids<-data.frame(Observed=nc.sids$SID74)
sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74)) 

niter<-100

#Permutation model
moran.boot<-boot(sids, statistic=moranI.boot, R=niter, listw=col.W, 
	n=length(ncCR85.nb), S0=Szero(col.W) )
plot(moran.boot)#Display results

#Multinomial model
moran.mboot<-boot(sids, statistic=moranI.pboot, sim="parametric", 
	ran.gen=multinom.sim,  R=niter, listw=col.W,n=length(ncCR85.nb), 
	S0=Szero(col.W) )
plot(moran.mboot)#Display results

#Poisson model
moran.pboot<-boot(sids, statistic=moranI.pboot, sim="parametric", 
	ran.gen=poisson.sim,  R=niter, listw=col.W,n=length(ncCR85.nb),
	S0=Szero(col.W) )
		
plot(moran.pboot)#Display results

#Poisson-Gamma model
moran.pgboot<-boot(sids, statistic=moranI.pboot, sim="parametric", 
	ran.gen=negbin.sim, R=niter,  listw=col.W,n=length(ncCR85.nb),
	S0=Szero(col.W) )
		
plot(moran.pgboot)#Display results
}

\references{
Moran, P. A. P. (1948). The interpretation os statistical maps. Journal of the Royal Statistical Society, Series B 10, 243-251.
}

\keyword{spatial}
