% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcem_heap.R
\name{max_heapify}
\alias{max_heapify}
\title{max_heapify: Part of DCEM package.}
\usage{
max_heapify(data, index, N)
}
\arguments{
\item{data}{(dataframe): The dataframe containing the key, value pairs.}

\item{index}{(numeric): Index of the node.}

\item{N}{(numeric): Size of the heap.}
}
\value{
data frame: The data frame containing the heap.
}
\description{
Implements the max-heapify process to create the heap. This function is for internal
use and is called by the \code{\link{dcem_star_cluster_uv}} (univariate data) and
\code{\link{dcem_star_cluster_mv}} (multivariate data).
}
\examples{

# Create a sample data frame
heap <- data.frame(keys=c(0,3,4,5), vals=c(7,7,4,6))

# Build the heap from the data frame.
heap <- build_heap(heap)

# Call max-heapify untill the last node

i = floor(nrow(heap)/2)
while (i>=1){
 heap = max_heapify(heap, i, nrow(heap))
 i = i-1
}

}
\references{
Using data to build a better EM: EM* for big data.

Hasan Kurban, Mark Jenne, Mehmet M. Dalkilic
(2016) <doi:https://doi.org/10.1007/s41060-017-0062-1>.
}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic
This work is partially supported by NCI Grant 1R01CA213466-01.
}
