% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcem_heap.R
\name{insert_node}
\alias{insert_node}
\title{insert_node: Part of DCEM package.}
\usage{
insert_node(heap, node)
}
\arguments{
\item{heap}{(dataframe): The dataframe holding the heap structure.}

\item{node}{(vector): A vector containing the key, value pair.}
}
\value{
data: The heap with the new node.
}
\description{
Implements node insertion in the heap structure. This function is for internal use
and is called by the \code{\link{dcem_star_cluster_uv}} (univariate data) and
\code{\link{dcem_star_cluster_mv}} (multivariate data).
}
\examples{

# Create a sample data frame
heap <- data.frame(keys=c(0), vals=c(7))

# Build the heap from the data frame.
heap <- build_heap(heap)

# Insert a new node in the heap.
heap <- insert_node(heap, c(1,2))

}
\references{
Using data to build a better EM: EM* for big data.

Hasan Kurban, Mark Jenne, Mehmet M. Dalkilic
(2016) <https://doi.org/10.1007/s41060-017-0062-1>.
}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic
This work is partially supported by NCI Grant 1R01CA213466-01.
}
