% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quote.R
\name{dbQuoteString}
\alias{dbQuoteString}
\title{Quote literal strings}
\usage{
dbQuoteString(conn, x, ...)
}
\arguments{
\item{conn}{A subclass of \linkS4class{DBIConnection}, representing
an active connection to an DBMS.}

\item{x}{A character vector to quote as string.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbQuoteString()} returns an object that can be coerced to \link{character},
of the same length as the input.
For an empty character vector this function returns a length-0 object.

When passing the returned object again to \code{dbQuoteString()}
as \code{x}
argument, it is returned unchanged.
Passing objects of class \link{SQL} should also return them unchanged.
(For backends it may be most convenient to return \link{SQL} objects
to achieve this behavior, but this is not required.)
}
\description{
Call this method to generate a string that is suitable for
use in a query as a string literal, to make sure that you
generate valid SQL and avoid SQL injection.
}
\section{Specification}{


The returned expression can be used in a \code{SELECT ...} query,
and for any scalar character \code{x} the value of
\code{dbGetQuery(paste0("SELECT ", dbQuoteString(x)))[[1]]}
must be identical to \code{x},
even if \code{x} contains
spaces,
quotes (single
or double),
backticks,
or newlines
(in any combination)
or is itself the result of a \code{dbQuoteString()} call coerced back to
character (even repeatedly).
If \code{x} is \code{NA}, the result must merely satisfy \code{\link[=is.na]{is.na()}}.
The strings \code{"NA"} or \code{"NULL"} are not treated specially.

\code{NA} should be translated to an unquoted SQL \code{NULL},
so that the query \code{SELECT * FROM (SELECT 1) a WHERE ... IS NULL}
returns one row.

}

\examples{
# Quoting ensures that arbitrary input is safe for use in a query
name <- "Robert'); DROP TABLE Students;--"
dbQuoteString(ANSI(), name)

# NAs become NULL
dbQuoteString(ANSI(), c("x", NA))

# SQL vectors are always passed through as is
var_name <- SQL("select")
var_name
dbQuoteString(ANSI(), var_name)

# This mechanism is used to prevent double escaping
dbQuoteString(ANSI(), dbQuoteString(ANSI(), name))
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}},
  \code{\link{dbQuoteIdentifier}}
}
