% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overall_comparison.R
\name{print.overall_comparison}
\alias{print.overall_comparison}
\title{Print overall_comparison object}
\usage{
\method{print}{overall_comparison}(x, ...)
}
\arguments{
\item{x}{an object of class \code{overall_comparison}}

\item{...}{other parameters}
}
\description{
Print overall_comparison object
}
\examples{
\donttest{
library("DALEXtra")
library("mlr")
task <- mlr::makeRegrTask(
  id = "R",
  data = apartments,
  target = "m2.price"
)
learner_lm <- mlr::makeLearner(
  "regr.lm"
)
model_lm <- mlr::train(learner_lm, task)
explainer_lm <- explain_mlr(model_lm, apartmentsTest, apartmentsTest$m2.price, label = "LM")

learner_rf <- mlr::makeLearner(
  "regr.ranger"
)
model_rf <- mlr::train(learner_rf, task)
explainer_rf <- explain_mlr(model_rf, apartmentsTest, apartmentsTest$m2.price, label = "RF")

learner_gbm <- mlr::makeLearner(
  "regr.gbm"
)
model_gbm <- mlr::train(learner_gbm, task)
explainer_gbm <- explain_mlr(model_gbm, apartmentsTest, apartmentsTest$m2.price, label = "gbm")

data <- overall_comparison(explainer_lm, list(explainer_gbm, explainer_rf), type = "regression")
print(data)
}
}
