% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_max_rates.R
\name{update_max_rates}
\alias{update_max_rates}
\title{Calculates the maximum rates for a Gillespie simulation}
\usage{
update_max_rates(
  gam,
  laa,
  lac,
  mu,
  hyper_pars = NULL,
  extcutoff,
  K,
  num_spec,
  num_immigrants,
  mainland_n,
  Amin,
  Amax
)
}
\arguments{
\item{gam}{A numeric with the per capita immigration rate.}

\item{laa}{A numeric with the per capita anagenesis rate.}

\item{lac}{A numeric with the per capita cladogenesis rate.}

\item{mu}{A numeric with the per capita extinction rate.}

\item{hyper_pars}{A named list of numeric hyperparameters for the rate
calculations as returned by \code{\link{create_hyper_pars}()}:
\itemize{
  \item{[1]: is d the scaling parameter for exponent for calculating
  cladogenesis rate}
  \item{[2]: is x the exponent for calculating extinction rate}
}}

\item{extcutoff}{A numeric with the cutoff for the the maximum extinction
rate preventing it from being too large and slowing down simulation.}

\item{K}{A numeric with carrying capacity.}

\item{num_spec}{A numeric with the current number of species.}

\item{num_immigrants}{A numeric with the current number of non-endemic
species (a.k.a non-endemic species).}

\item{mainland_n}{A numeric stating the number of mainland species, that
is the number of species that can potentially colonize the island.
If using a clade-specific diversity dependence, this value is set to 1.
If using an island-wide diversity dependence, this value is set to the
number of mainland species.}

\item{Amin}{A numeric value for minimum island area during the simulation.}

\item{Amax}{A numeric value for maximum island area during the simulation.}
}
\value{
a named list with the updated effective rates.
}
\description{
Internal function that updates the all the max rates at time t.
}
\seealso{
\code{\link{update_rates}()}

Other rate calculations: 
\code{\link{DAISIE_plot_area}()},
\code{\link{get_ana_rate}()},
\code{\link{get_ext_rate}()},
\code{\link{get_immig_rate}()},
\code{\link{island_area_vector}()},
\code{\link{island_area}()},
\code{\link{update_rates}()}
}
\concept{rate calculations}
\keyword{internal}
